/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.datasource;

import java.io.File;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.datasource.DataSourceQueryChooserDialog;
import org.locationtech.jts.jump.workbench.datasource.FileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;

public class SaveFileDataSourceQueryChooser
extends FileDataSourceQueryChooser {
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    private WorkbenchContext context;

    public SaveFileDataSourceQueryChooser(Class dataSourceClass, String description, String[] extensions, WorkbenchContext context) {
        super(dataSourceClass, description, extensions);
        this.context = context;
    }

    @Override
    protected FileDataSourceQueryChooser.FileChooserPanel getFileChooserPanel() {
        String FILE_CHOOSER_PANEL_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - SAVE FILE CHOOSER PANEL";
        if (this.blackboard().get(FILE_CHOOSER_PANEL_KEY) == null) {
            final JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setControlButtonsAreShown(false);
            this.blackboard().put(FILE_CHOOSER_PANEL_KEY, new FileDataSourceQueryChooser.FileChooserPanel(fileChooser, this.blackboard()));
            if (PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY)));
            }
            fileChooser.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    if (event.getAncestor() instanceof DataSourceQueryChooserDialog) {
                        fileChooser.rescanCurrentDirectory();
                    }
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
        }
        return (FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY);
    }

    private Blackboard blackboard() {
        return this.context.getBlackboard();
    }

    @Override
    public Collection getDataSourceQueries() {
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_DIRECTORY_KEY, this.getFileChooserPanel().getChooser().getCurrentDirectory().toString());
        return super.getDataSourceQueries();
    }
}

