/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.driver;

import java.io.File;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.GMLWriter;
import org.locationtech.jts.jump.workbench.driver.AbstractOutputDriver;
import org.locationtech.jts.jump.workbench.driver.DriverManager;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.AbstractDriverPanel;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.GMLFileDriverPanel;

public class GMLFileOutputDriver
extends AbstractOutputDriver {
    private GMLFileDriverPanel panel;
    private GMLWriter writer = new GMLWriter();

    @Override
    public void output(Layer layer) throws Exception {
        File selectedFile = this.panel.getGMLFile();
        String fname = selectedFile.getAbsolutePath();
        DriverProperties dp = new DriverProperties();
        dp.set("File", fname);
        dp.set("TemplateFile", this.panel.getTemplateFile().getAbsolutePath());
        this.writer.write((FeatureCollection)layer.getFeatureCollectionWrapper(), dp);
    }

    @Override
    public String toString() {
        return "GML 2.0";
    }

    @Override
    public AbstractDriverPanel getPanel() {
        return this.panel;
    }

    @Override
    public void initialize(DriverManager driverManager, ErrorHandler errorHandler) {
        super.initialize(driverManager, errorHandler);
        this.panel = new GMLFileDriverPanel(errorHandler);
        this.panel.setGMLFileMustExist(false);
        this.panel.setTemplateFileDescription("JCS GML Output Template File");
        this.panel.addPossibleTemplateExtension(".jot");
        this.panel.addPossibleTemplateExtension("_output.xml");
    }
}

