/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.SystemLayerFinder;
import org.locationtech.jts.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.CircleLineStringEndpointStyle;

public abstract class AbstractVectorLayerFinder
extends SystemLayerFinder {
    private Color color;

    public AbstractVectorLayerFinder(String layerName, LayerManagerProxy layerManagerProxy, Color color) {
        super(layerName, layerManagerProxy);
        this.color = color;
    }

    public List getVectors() {
        if (this.getLayer() == null) {
            return new ArrayList();
        }
        return FeatureUtil.toGeometries(this.getLayer().getFeatureCollectionWrapper().getFeatures());
    }

    @Override
    protected void applyStyles(Layer layer) {
        if (null == layer.getStyle(ArrowLineStringEndpointStyle.class)) {
            layer.addStyle(new ArrowLineStringEndpointStyle.SolidEnd());
        }
        if (null == layer.getStyle(CircleLineStringEndpointStyle.Start.class)) {
            layer.addStyle(new CircleLineStringEndpointStyle.Start());
        }
        layer.getBasicStyle().setLineColor(this.color);
        layer.getBasicStyle().setFillColor(this.color);
        layer.getBasicStyle().setRenderingFill(false);
        layer.setDrawingLast(true);
    }
}

