/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.jump.workbench.model.CategoryEventType;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.util.Assert;

public class Category {
    private ArrayList layerables = new ArrayList();
    private String name;
    private LayerManager layerManager;

    public void setName(String name) {
        this.name = name;
        this.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
    }

    public void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    public void fireCategoryChanged(CategoryEventType type) {
        if (this.getLayerManager() == null) {
            return;
        }
        this.getLayerManager().fireCategoryChanged(this, type);
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public List getPersistentLayerables() {
        ArrayList<Layerable> persistentLayerables = new ArrayList<Layerable>();
        for (Layerable layerable : this.layerables) {
            if (layerable instanceof Layer && !((Layer)layerable).hasReadableDataSource()) continue;
            persistentLayerables.add(layerable);
        }
        return persistentLayerables;
    }

    public List getLayerables() {
        return Collections.unmodifiableList(this.layerables);
    }

    public void remove(Layerable layerable) {
        Assert.isTrue((boolean)this.contains(layerable));
        this.layerables.remove(layerable);
    }

    public int indexOf(Layerable layerable) {
        return this.layerables.indexOf(layerable);
    }

    public boolean contains(Layerable layerable) {
        return this.layerables.contains(layerable);
    }

    public void add(int index, Layerable layerable) {
        this.layerables.add(index, layerable);
        if (this.getLayerManager() != null) {
            this.getLayerManager().fireLayerChanged(layerable, LayerEventType.ADDED);
        }
    }

    public void addPersistentLayerable(Layerable layerable) {
        this.add(this.layerables.size(), layerable);
    }

    public boolean isEmpty() {
        return this.layerables.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

