/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.awt.Color;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.SystemLayerFinder;

public class FenceLayerFinder
extends SystemLayerFinder {
    public static final String LAYER_NAME = "Fence";

    public FenceLayerFinder(LayerManagerProxy layerManagerProxy) {
        super(LAYER_NAME, layerManagerProxy);
    }

    public Geometry getFence() {
        if (this.getLayer() == null) {
            return null;
        }
        if (this.getLayer().getFeatureCollectionWrapper().isEmpty()) {
            return null;
        }
        return ((Feature)this.getLayer().getFeatureCollectionWrapper().iterator().next()).getGeometry();
    }

    @Override
    protected void applyStyles(Layer layer) {
        layer.getBasicStyle().setLineColor(Color.blue);
        layer.getBasicStyle().setRenderingLine(true);
        layer.getBasicStyle().setRenderingFill(false);
        layer.setDrawingLast(true);
    }

    private Feature toFeature(Geometry fence, FeatureSchema schema) {
        BasicFeature feature = new BasicFeature(schema);
        feature.setGeometry(fence);
        return feature;
    }

    public void setFence(Geometry fence) {
        if (this.getLayer() == null) {
            this.createLayer();
        }
        if (fence != null) {
            this.getLayer().getFeatureCollectionWrapper().clear();
            this.getLayer().getFeatureCollectionWrapper().add(this.toFeature(fence, this.getLayer().getFeatureCollectionWrapper().getFeatureSchema()));
        }
    }
}

