/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureCollectionWrapper;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.io.datasource.DataSourceQuery;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.model.AbstractLayerable;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEventType;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.ObservableFeatureCollection;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import org.locationtech.jts.jump.workbench.ui.renderer.style.BasicStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.LabelStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.SquareVertexStyle;
import org.locationtech.jts.jump.workbench.ui.renderer.style.Style;
import org.locationtech.jts.jump.workbench.ui.renderer.style.VertexStyle;
import org.locationtech.jts.util.Assert;

public class Layer
extends AbstractLayerable
implements LayerManagerProxy {
    public static final String FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE = Layer.class.getName() + " - FIRING APPEARANCE CHANGED ON ATTRIBUTE CHANGE";
    private String description = "";
    private boolean drawingLast = false;
    private FeatureCollectionWrapper featureCollectionWrapper;
    private ArrayList styles = new ArrayList();
    private boolean synchronizingLineColor = true;
    private boolean editable = false;
    private LayerListener layerListener = null;
    private Blackboard blackboard = new Blackboard(){
        private static final long serialVersionUID = 6504993615735124204L;
        {
            this.put(FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE, true);
        }
    };
    private boolean featureCollectionModified = false;
    private DataSourceQuery dataSourceQuery;

    public Layer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer(String name, Color fillColor, FeatureCollection featureCollection, LayerManager layerManager) {
        super(name, layerManager);
        Assert.isTrue((featureCollection != null ? 1 : 0) != 0);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.addStyle(new BasicStyle());
            this.addStyle(new SquareVertexStyle());
            this.addStyle(new LabelStyle());
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
        this.getBasicStyle().setFillColor(fillColor);
        this.getBasicStyle().setLineColor(Layer.defaultLineColor(fillColor));
        this.getBasicStyle().setAlpha(150);
        this.setFeatureCollection(featureCollection);
    }

    public static Color defaultLineColor(Color fillColor) {
        return fillColor.darker();
    }

    public void setDescription(String description) {
        Assert.isTrue((description != null ? 1 : 0) != 0, (String)"Java2XML requires that the description be non-null. Use an empty string if necessary.");
        this.description = description;
    }

    public void setDrawingLast(boolean drawingLast) {
        this.drawingLast = drawingLast;
        this.fireAppearanceChanged();
    }

    public void setFeatureCollection(final FeatureCollection featureCollection) {
        final FeatureCollection oldFeatureCollection = this.featureCollectionWrapper != null ? this.featureCollectionWrapper.getUltimateWrappee() : AddNewLayerPlugIn.createBlankFeatureCollection();
        ObservableFeatureCollection observableFeatureCollection = new ObservableFeatureCollection(featureCollection);
        observableFeatureCollection.checkNotWrappingSameClass();
        observableFeatureCollection.add(new ObservableFeatureCollection.Listener(){

            @Override
            public void featuresAdded(Collection features) {
                Layer.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.ADDED, Layer.this);
            }

            @Override
            public void featuresRemoved(Collection features) {
                Layer.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.DELETED, Layer.this);
            }
        });
        if (this.getLayerManager() != null && this.getLayerManager().getLayers().contains(this)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!oldFeatureCollection.isEmpty()) {
                        Layer.this.getLayerManager().fireFeaturesChanged(oldFeatureCollection.getFeatures(), FeatureEventType.DELETED, Layer.this);
                    }
                    if (!featureCollection.isEmpty()) {
                        Layer.this.getLayerManager().fireFeaturesChanged(featureCollection.getFeatures(), FeatureEventType.ADDED, Layer.this);
                    }
                }
            });
        }
        this.setFeatureCollectionWrapper(observableFeatureCollection);
    }

    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSynchronizingLineColor(boolean synchronizingLineColor) {
        this.synchronizingLineColor = synchronizingLineColor;
        this.fireAppearanceChanged();
    }

    public BasicStyle getBasicStyle() {
        return (BasicStyle)this.getStyle(BasicStyle.class);
    }

    public VertexStyle getVertexStyle() {
        return (VertexStyle)this.getStyle(VertexStyle.class);
    }

    public LabelStyle getLabelStyle() {
        return (LabelStyle)this.getStyle(LabelStyle.class);
    }

    public String getDescription() {
        return this.description;
    }

    public FeatureCollectionWrapper getFeatureCollectionWrapper() {
        return this.featureCollectionWrapper;
    }

    protected void setFeatureCollectionWrapper(FeatureCollectionWrapper featureCollectionWrapper) {
        this.featureCollectionWrapper = featureCollectionWrapper;
    }

    public Style getStyle(Class c) {
        for (Style p : this.styles) {
            if (!c.isInstance(p)) continue;
            return p;
        }
        return null;
    }

    public List getStyles() {
        return Collections.unmodifiableList(this.styles);
    }

    public boolean hasReadableDataSource() {
        return this.dataSourceQuery != null && this.dataSourceQuery.getDataSource().isReadable();
    }

    public boolean isDrawingLast() {
        return this.drawingLast;
    }

    public boolean isSynchronizingLineColor() {
        return this.synchronizingLineColor;
    }

    public void addStyle(Style style) {
        this.styles.add(style);
        this.fireAppearanceChanged();
    }

    public void dispose() {
        this.setFeatureCollection(AddNewLayerPlugIn.createBlankFeatureCollection());
    }

    public void removeStyle(Style p) {
        Assert.isTrue((boolean)this.styles.remove(p));
        this.fireAppearanceChanged();
    }

    public Collection cloneStyles() {
        ArrayList<Object> styleClones = new ArrayList<Object>();
        for (Style style : this.getStyles()) {
            styleClones.add(style.clone());
        }
        return styleClones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyles(Collection newStyles) {
        boolean firingEvents = this.getLayerManager().isFiringEvents();
        this.getLayerManager().setFiringEvents(false);
        try {
            for (Style style : new ArrayList(this.getStyles())) {
                this.removeStyle(style);
            }
            for (Style style : newStyles) {
                this.addStyle(style);
            }
        }
        finally {
            this.getLayerManager().setFiringEvents(firingEvents);
        }
        this.fireAppearanceChanged();
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        if (layerManager != null) {
            layerManager.removeLayerListener(this.getLayerListener());
        }
        super.setLayerManager(layerManager);
        layerManager.addLayerListener(this.getLayerListener());
    }

    private LayerListener getLayerListener() {
        if (this.layerListener == null) {
            this.layerListener = new LayerListener(){

                @Override
                public void featuresChanged(FeatureEvent e) {
                    if (e.getLayer() == Layer.this) {
                        Layer.this.setFeatureCollectionModified(true);
                        if (e.getType() != FeatureEventType.ATTRIBUTES_MODIFIED || Layer.this.getBlackboard().get(FIRING_APPEARANCE_CHANGED_ON_ATTRIBUTE_CHANGE, true)) {
                            Layer.this.fireAppearanceChanged();
                        }
                    }
                }

                @Override
                public void layerChanged(LayerEvent e) {
                }

                @Override
                public void categoryChanged(CategoryEvent e) {
                }
            };
        }
        return this.layerListener;
    }

    @Override
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public static UndoableCommand addUndo(final String layerName, final LayerManagerProxy proxy, final UndoableCommand wrappeeCommand) {
        return new UndoableCommand(wrappeeCommand.getName()){
            private Layer layer;
            private String categoryName;
            private Collection features;
            private boolean visible;

            private Layer currentLayer() {
                return proxy.getLayerManager().getLayer(layerName);
            }

            @Override
            public void execute() {
                this.layer = this.currentLayer();
                if (this.layer != null) {
                    this.features = new ArrayList(this.layer.getFeatureCollectionWrapper().getFeatures());
                    this.categoryName = this.layer.getName();
                    this.visible = this.layer.isVisible();
                }
                wrappeeCommand.execute();
            }

            @Override
            public void unexecute() {
                wrappeeCommand.unexecute();
                if (this.layer == null && this.currentLayer() != null) {
                    proxy.getLayerManager().remove(this.currentLayer());
                }
                if (this.layer != null && this.currentLayer() == null) {
                    proxy.getLayerManager().addLayer(this.categoryName, this.layer);
                }
                if (this.layer != null) {
                    this.layer.getFeatureCollectionWrapper().clear();
                    this.layer.getFeatureCollectionWrapper().addAll(this.features);
                    this.layer.setVisible(this.visible);
                }
            }
        };
    }

    public static void tryToInvalidateEnvelope(Layer layer) {
        if (layer.getFeatureCollectionWrapper().getUltimateWrappee() instanceof FeatureDataset) {
            ((FeatureDataset)layer.getFeatureCollectionWrapper().getUltimateWrappee()).invalidateEnvelope();
        }
    }

    public DataSourceQuery getDataSourceQuery() {
        return this.dataSourceQuery;
    }

    public Layer setDataSourceQuery(DataSourceQuery dataSourceQuery) {
        this.dataSourceQuery = dataSourceQuery;
        return this;
    }

    public boolean isFeatureCollectionModified() {
        return this.featureCollectionModified;
    }

    public Layer setFeatureCollectionModified(boolean featureCollectionModified) {
        if (this.featureCollectionModified == featureCollectionModified) {
            return this;
        }
        this.featureCollectionModified = featureCollectionModified;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        return this;
    }
}

