/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureCollectionWrapper;

public class ObservableFeatureCollection
extends FeatureCollectionWrapper {
    private ArrayList listeners = new ArrayList();

    public ObservableFeatureCollection(FeatureCollection fc) {
        super(fc);
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void add(Feature feature) {
        super.add(feature);
        this.fireFeaturesAdded(Arrays.asList(feature));
    }

    @Override
    public void remove(Feature feature) {
        super.remove(feature);
        this.fireFeaturesRemoved(Arrays.asList(feature));
    }

    private void fireFeaturesAdded(Collection features) {
        for (Listener listener : this.listeners) {
            listener.featuresAdded(features);
        }
    }

    private void fireFeaturesRemoved(Collection features) {
        for (Listener listener : this.listeners) {
            listener.featuresRemoved(features);
        }
    }

    @Override
    public void addAll(Collection features) {
        super.addAll(features);
        this.fireFeaturesAdded(features);
    }

    @Override
    public void removeAll(Collection features) {
        super.removeAll(features);
        this.fireFeaturesRemoved(features);
    }

    @Override
    public Collection remove(Envelope env) {
        Collection features = super.remove(env);
        this.fireFeaturesRemoved(features);
        return features;
    }

    public static interface Listener {
        public void featuresAdded(Collection var1);

        public void featuresRemoved(Collection var1);
    }
}

