/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.plugin;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.TaskFrameProxy;
import org.locationtech.jts.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import org.locationtech.jts.util.Assert;

public class EnableCheckFactory {
    private WorkbenchContext workbenchContext;

    public EnableCheckFactory(WorkbenchContext workbenchContext) {
        Assert.isTrue((workbenchContext != null ? 1 : 0) != 0);
        this.workbenchContext = workbenchContext;
    }

    public EnableCheck createTaskWindowMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrame) ? "A Task Window must be active" : null;
            }
        };
    }

    public EnableCheck createWindowWithSelectionManagerMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof SelectionManagerProxy) ? "A window with a selection manager must be active" : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerManagerMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerManagerProxy) ? "A window with a layer manager must be active" : null;
            }
        };
    }

    public EnableCheck createWindowWithAssociatedTaskFrameMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrameProxy) ? "A window with an associated task frame must be active" : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerNamePanelMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerNamePanelProxy) ? "A window with a layer-name panel must be active" : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerViewPanelMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy) ? "A window with a layer-view panel must be active" : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedFeaturesCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection layersWithSelectedFeatures = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
                return layersWithSelectedFeatures.size() > 1 ? "Only one layer may have selected features" : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedItemsCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection layersWithSelectedItems = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems();
                return layersWithSelectedItems.size() > 1 ? "Only one layer may have selected items" : null;
            }
        };
    }

    public EnableCheck createSelectedItemsLayersMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
                    if (layer.isEditable()) continue;
                    return "Selected items' layers must be editable (" + layer.getName() + ")";
                }
                return null;
            }
        };
    }

    public EnableCheck createExactlyNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? "Exactly " + n + " categor" + StringUtil.ies(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createExactlyNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size() ? "Exactly " + n + " layer" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustBeSelectedCheck(int n) {
        return this.createExactlyNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedCategories().size() ? "At least " + n + " categor" + StringUtil.ies(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.workbenchContext.getLayerNamePanel().selectedNodes(layerableClass).size() ? "At least " + n + " layer" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustBeSelectedCheck(int n) {
        return this.createAtLeastNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNLayersMustBeEditableCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.workbenchContext.getLayerManager().getEditableLayers().size() ? "At least " + n + " layer" + StringUtil.s(n) + " must be editable" : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.workbenchContext.getLayerManager().size() ? "At least " + n + " layer" + StringUtil.s(n) + " must exist" : null;
            }
        };
    }

    public EnableCheck createAtMostNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n < EnableCheckFactory.this.workbenchContext.getLayerManager().size() ? "At most " + n + " layer" + StringUtil.s(n) + " must exist" : null;
            }
        };
    }

    public EnableCheck createExactlyNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != EnableCheckFactory.this.vectorCount() ? "Exactly " + n + " vector" + StringUtil.s(n) + " must be drawn" : null;
            }
        };
    }

    public EnableCheck createAtLeastNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > EnableCheckFactory.this.vectorCount() ? "At least " + n + " vector" + StringUtil.s(n) + " must be drawn" : null;
            }
        };
    }

    public EnableCheck createAtLeastNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().size() ? "At least " + n + " feature" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createAtLeastNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems().size() ? "At least " + n + " item" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().size() ? "Exactly " + n + " feature" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createExactlyNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems().size() ? "Exactly " + n + " item" + StringUtil.s(n) + " must be selected" : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems().size() ? "Exactly " + n + " layer" + StringUtil.s(n) + " must have selected items" : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItems().size() ? "Exactly " + n + " feature" + StringUtil.s(n) + " must have selected items" : null;
            }
        };
    }

    public EnableCheck createSelectedLayersMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : Arrays.asList(EnableCheckFactory.this.workbenchContext.getLayerNamePanel().getSelectedLayers())) {
                    if (layer.isEditable()) continue;
                    return "Selected layers must be editable (" + layer.getName() + ")";
                }
                return null;
            }
        };
    }

    public EnableCheck createFenceMustBeDrawnCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return null == EnableCheckFactory.this.workbenchContext.getLayerViewPanel().getFence() ? "A fence must be drawn" : null;
            }
        };
    }

    public EnableCheck createBetweenNAndMVectorsMustBeDrawnCheck(final int min, final int max) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return EnableCheckFactory.this.vectorCount() > max || EnableCheckFactory.this.vectorCount() < min ? "Between " + min + " and " + max + " vectors must be drawn" : null;
            }
        };
    }

    private int vectorCount() {
        return new WarpingVectorLayerFinder(this.workbenchContext).getVectors().size();
    }

    public EnableCheck createAtLeastNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItems().size() ? "At least " + n + " feature" + StringUtil.s(n) + " must have selected items" : null;
            }
        };
    }
}

