/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.ui.AttributeTablePanel;
import org.locationtech.jts.jump.workbench.ui.AttributeTablePanelListener;
import org.locationtech.jts.jump.workbench.ui.InfoModel;
import org.locationtech.jts.jump.workbench.ui.InfoModelListener;
import org.locationtech.jts.jump.workbench.ui.LayerTableModel;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import org.locationtech.jts.util.Assert;

public class AttributePanel
extends JPanel
implements InfoModelListener,
AttributeTablePanelListener {
    private SelectionManager selectionManager;
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private HashMap layerToTablePanelMap = new HashMap();
    private InfoModel model;
    private JPanel fillerPanel = new JPanel();
    private WorkbenchContext workbenchContext;
    private ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private Row nullRow = new Row(){

        @Override
        public boolean isFirstRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public boolean isLastRow() {
            return AttributePanel.this.rowCount() == 0;
        }

        @Override
        public AttributeTablePanel getPanel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Row nextRow() {
            return this.firstRow();
        }

        @Override
        public Row previousRow() {
            return this.firstRow();
        }

        private Row firstRow() {
            return new BasicRow(AttributePanel.this.getTablePanel((Layer)AttributePanel.this.getModel().getLayers().get(0)), 0);
        }

        @Override
        public Feature getFeature() {
            throw new UnsupportedOperationException();
        }
    };
    private TaskFrame taskFrame;
    private LayerManagerProxy layerManagerProxy;

    protected AttributePanel(InfoModel model, WorkbenchContext workbenchContext, TaskFrame taskFrame, LayerManagerProxy layerManagerProxy) {
        this.selectionManager = new SelectionManager(null, layerManagerProxy);
        this.selectionManager.setPanelUpdatesEnabled(false);
        this.taskFrame = taskFrame;
        this.workbenchContext = workbenchContext;
        this.layerManagerProxy = layerManagerProxy;
        this.setModel(model);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AttributeTablePanel getTablePanel(Layer layer) {
        return (AttributeTablePanel)this.layerToTablePanelMap.get(layer);
    }

    public InfoModel getModel() {
        return this.model;
    }

    public void setModel(InfoModel model) {
        this.model = model;
        model.addListener(this);
    }

    @Override
    public void layerAdded(LayerTableModel layerTableModel) {
        this.addTablePanel(layerTableModel);
    }

    @Override
    public void layerRemoved(LayerTableModel layerTableModel) {
        this.removeTablePanel(layerTableModel);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
    }

    private void removeTablePanel(LayerTableModel layerTableModel) {
        Assert.isTrue((boolean)this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()));
        this.remove(this.getTablePanel(layerTableModel.getLayer()));
        this.layerToTablePanelMap.remove(layerTableModel.getLayer());
        this.revalidate();
        this.repaint();
        this.updateSelectionManager();
    }

    private void addTablePanel(final LayerTableModel layerTableModel) {
        Assert.isTrue((!this.layerToTablePanelMap.containsKey(layerTableModel.getLayer()) ? 1 : 0) != 0);
        final AttributeTablePanel tablePanel = new AttributeTablePanel(layerTableModel, this.workbenchContext);
        tablePanel.addListener(this);
        this.layerToTablePanelMap.put(layerTableModel.getLayer(), tablePanel);
        this.remove(this.fillerPanel);
        this.add((Component)tablePanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(0, this.getComponentCount(), 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
        tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int row = tablePanel.getTable().rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    features.add(layerTableModel.getFeature(row));
                    if (AttributePanel.this.taskFrame.isVisible()) {
                        AttributePanel.this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(features), AttributePanel.this.taskFrame.getLayerViewPanel());
                    }
                }
                catch (Throwable t) {
                    AttributePanel.this.workbenchContext.getErrorHandler().handleThrowable(t);
                }
            }
        });
        tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AttributePanel.this.updateSelectionManager();
            }
        });
        this.updateSelectionManager();
    }

    private void updateSelectionManager() {
        this.selectionManager.clear();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            this.selectionManager.getFeatureSelection().selectItems(tablePanel.getModel().getLayer(), tablePanel.getSelectedFeatures());
        }
    }

    public int rowCount() {
        int rowCount = 0;
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            rowCount += tablePanel.getTable().getRowCount();
        }
        return rowCount;
    }

    public void flashSelectedFeatures() throws NoninvertibleTransformException {
        this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(this.selectedFeatures()), this.taskFrame.getLayerViewPanel());
    }

    public void zoom(Collection features) throws NoninvertibleTransformException {
        this.zoomToSelectedItemsPlugIn.zoom(FeatureUtil.toGeometries(features), this.taskFrame.getLayerViewPanel());
    }

    public Collection selectedFeatures() {
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            int[] selectedRows = tablePanel.getTable().getSelectedRows();
            for (int j = 0; j < selectedRows.length; ++j) {
                selectedFeatures.add(tablePanel.getModel().getFeature(selectedRows[j]));
            }
        }
        return selectedFeatures;
    }

    public void selectInLayerViewPanel() {
        this.taskFrame.getLayerViewPanel().getSelectionManager().clear();
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            int[] selectedRows = tablePanel.getTable().getSelectedRows();
            ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
            for (int j = 0; j < selectedRows.length; ++j) {
                selectedFeatures.add(tablePanel.getModel().getFeature(selectedRows[j]));
            }
            this.taskFrame.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(tablePanel.getModel().getLayer(), selectedFeatures);
        }
    }

    public Row topSelectedRow() {
        for (AttributeTablePanel panel : this.layerToTablePanelMap.values()) {
            int selectedRow = panel.getTable().getSelectedRow();
            if (selectedRow == -1) continue;
            return new BasicRow(panel, selectedRow);
        }
        return this.nullRow;
    }

    @Override
    public void selectionReplaced(AttributeTablePanel panel) {
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            if (tablePanel == panel) continue;
            tablePanel.getTable().clearSelection();
        }
    }

    public void clearSelection() {
        for (AttributeTablePanel tablePanel : this.layerToTablePanelMap.values()) {
            tablePanel.getTable().clearSelection();
        }
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    private class BasicRow
    implements Row {
        private AttributeTablePanel panel = null;
        private int index;

        public BasicRow(AttributeTablePanel panel, int index) {
            this.panel = panel;
            this.index = index;
        }

        @Override
        public boolean isFirstRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(0) && this.index == 0;
        }

        @Override
        public boolean isLastRow() {
            return this.panel.getModel().getLayer() == AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().size() - 1) && this.index == this.panel.getTable().getRowCount() - 1;
        }

        @Override
        public AttributeTablePanel getPanel() {
            return this.panel;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Row previousRow() {
            if (this.isFirstRow()) {
                return this;
            }
            if (this.index > 0) {
                return new BasicRow(this.panel, this.index - 1);
            }
            return new BasicRow(this.previousPanel(), this.previousPanel().getTable().getRowCount() - 1);
        }

        @Override
        public Row nextRow() {
            if (this.isLastRow()) {
                return this;
            }
            if (this.index < this.panel.getTable().getRowCount() - 1) {
                return new BasicRow(this.panel, this.index + 1);
            }
            return new BasicRow(this.nextPanel(), 0);
        }

        private AttributeTablePanel previousPanel() {
            return AttributePanel.this.getTablePanel(this.previousLayer());
        }

        private AttributeTablePanel nextPanel() {
            return AttributePanel.this.getTablePanel(this.nextLayer());
        }

        private Layer previousLayer() {
            return (Layer)AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) - 1);
        }

        private Layer nextLayer() {
            return (Layer)AttributePanel.this.getModel().getLayers().get(AttributePanel.this.getModel().getLayers().indexOf(this.panel.getModel().getLayer()) + 1);
        }

        @Override
        public Feature getFeature() {
            return this.panel.getModel().getFeature(this.index);
        }
    }

    public static interface Row {
        public boolean isFirstRow();

        public boolean isLastRow();

        public AttributeTablePanel getPanel();

        public int getIndex();

        public Row nextRow();

        public Row previousRow();

        public Feature getFeature();
    }
}

