/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.ui.AbstractSelection;
import org.locationtech.jts.jump.workbench.ui.GeometryEditor;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelContext;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.util.Assert;

public class EditTransaction {
    private List features;
    private List originalGeometries;
    private List proposedGeometries;
    private Layer layer;
    private String name;
    private boolean rollingBackInvalidEdits;
    public static final String ROLLING_BACK_INVALID_EDITS_KEY = EditTransaction.class.getName() + " - ROLLING_BACK_INVALID_EDITS";
    private LayerViewPanelContext layerViewPanelContext;
    private GeometryEditor editor = new GeometryEditor();
    private boolean allowAddingAndRemovingFeatures;

    public EditTransaction(Collection features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanel layerViewPanel) {
        this(features, name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanel.getContext());
    }

    public EditTransaction(Collection features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanelContext layerViewPanelContext) {
        this.layerViewPanelContext = layerViewPanelContext;
        this.layer = layer;
        this.rollingBackInvalidEdits = rollingBackInvalidEdits;
        this.allowAddingAndRemovingFeatures = allowAddingAndRemovingFeatures;
        this.name = name;
        this.features = new ArrayList(features);
        this.originalGeometries = this.geometryClones(features);
        this.proposedGeometries = this.geometryClones(features);
    }

    public static EditTransaction createTransactionOnSelection(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, LayerViewPanelContext layerViewPanelContext, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures) {
        Map featureToNewGeometryMap = EditTransaction.featureToNewGeometryMap(editor, selectionManagerProxy, layer);
        EditTransaction transaction = new EditTransaction(featureToNewGeometryMap.keySet(), name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanelContext);
        transaction.setGeometries(featureToNewGeometryMap);
        return transaction;
    }

    public static Map featureToNewGeometryMap(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, Layer layer) {
        HashMap<Feature, Geometry> featureToNewGeometryMap = new HashMap<Feature, Geometry>();
        for (Feature feature : selectionManagerProxy.getSelectionManager().getFeaturesWithSelectedItems(layer)) {
            Geometry newGeometry = (Geometry)feature.getGeometry().clone();
            ArrayList selectedItems = new ArrayList();
            for (AbstractSelection selection : selectionManagerProxy.getSelectionManager().getSelections()) {
                selectedItems.addAll(selection.items(newGeometry, selection.getSelectedItemIndices(layer, feature)));
            }
            newGeometry = editor.edit(newGeometry, selectedItems);
            featureToNewGeometryMap.put(feature, newGeometry);
        }
        return featureToNewGeometryMap;
    }

    public Geometry getGeometry(int i) {
        return (Geometry)this.proposedGeometries.get(i);
    }

    public Geometry getGeometry(Feature feature) {
        return this.getGeometry(this.features.indexOf(feature));
    }

    public void setGeometry(Feature feature, Geometry geometry) {
        this.setGeometry(this.features.indexOf(feature), geometry);
    }

    public void setGeometries(Map featureToGeometryMap) {
        for (Feature feature : featureToGeometryMap.keySet()) {
            this.setGeometry(feature, (Geometry)featureToGeometryMap.get(feature));
        }
    }

    public void setGeometry(int i, Geometry geometry) {
        this.proposedGeometries.set(i, this.editor.removeRepeatedPoints(geometry));
    }

    public boolean commit() {
        return EditTransaction.commit(Collections.singleton(this));
    }

    public static boolean commit(Collection editTransactions) {
        return EditTransaction.commit(editTransactions, new SuccessAction(){

            @Override
            public void run() {
            }
        });
    }

    public static boolean commit(Collection editTransactions, SuccessAction successAction) {
        if (editTransactions.isEmpty()) {
            return true;
        }
        final ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
        for (EditTransaction editTransaction : editTransactions) {
            editTransaction.clearEnvelopeCaches();
            if (!editTransaction.proposedGeometriesValid()) {
                if (editTransaction.rollingBackInvalidEdits) {
                    editTransaction.layerViewPanelContext.warnUser("The new geometry is invalid. Cancelled.");
                    return false;
                }
                editTransaction.layerViewPanelContext.warnUser("The new geometry is invalid.");
            }
            commands.add(editTransaction.createCommand());
        }
        successAction.run();
        UndoableCommand command = new UndoableCommand(((UndoableCommand)commands.iterator().next()).getName()){

            @Override
            public void execute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.execute();
                }
            }

            @Override
            public void unexecute() {
                for (UndoableCommand subCommand : commands) {
                    subCommand.unexecute();
                }
            }
        };
        command.execute();
        ((EditTransaction)editTransactions.iterator().next()).layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        return true;
    }

    public boolean commit(SuccessAction successAction) {
        return EditTransaction.commit(Collections.singleton(this), successAction);
    }

    public void clearEnvelopeCaches() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry proposedGeometry = (Geometry)this.proposedGeometries.get(i);
            proposedGeometry.geometryChanged();
        }
    }

    public boolean proposedGeometriesValid() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry proposedGeometry = (Geometry)this.proposedGeometries.get(i);
            if (proposedGeometry.isValid()) continue;
            return false;
        }
        return true;
    }

    private UndoableCommand createCommand() {
        UndoableCommand command = new UndoableCommand(this.name){

            @Override
            public void execute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.proposedGeometries, EditTransaction.this.originalGeometries, EditTransaction.this.layer);
            }

            @Override
            public void unexecute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.originalGeometries, EditTransaction.this.proposedGeometries, EditTransaction.this.layer);
            }
        };
        return command;
    }

    private List geometryClones(Collection features) {
        ArrayList<Object> geometryClones = new ArrayList<Object>();
        for (Feature feature : features) {
            geometryClones.add(feature.getGeometry().clone());
        }
        return geometryClones;
    }

    private void changeGeometries(List newGeometries, List oldGeometries, Layer layer) {
        ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
        ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
        ArrayList<Feature> featuresToAdd = new ArrayList<Feature>();
        ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
        for (int i = 0; i < this.size(); ++i) {
            Feature feature = (Feature)this.features.get(i);
            Geometry oldGeometry = (Geometry)oldGeometries.get(i);
            Geometry newGeometry = (Geometry)newGeometries.get(i);
            if (this.allowAddingAndRemovingFeatures && oldGeometry.isEmpty() && !newGeometry.isEmpty()) {
                featuresToAdd.add(feature);
                continue;
            }
            if (this.allowAddingAndRemovingFeatures && newGeometry.isEmpty() && !oldGeometry.isEmpty()) {
                featuresToRemove.add(feature);
                continue;
            }
            modifiedFeatures.add(feature);
            modifiedFeaturesOldClones.add(feature.clone());
            feature.setGeometry(newGeometry);
        }
        Layer.tryToInvalidateEnvelope(layer);
        if (!featuresToRemove.isEmpty()) {
            layer.getFeatureCollectionWrapper().removeAll(featuresToRemove);
        }
        if (!featuresToAdd.isEmpty()) {
            layer.getFeatureCollectionWrapper().addAll(featuresToAdd);
        }
        if (!modifiedFeatures.isEmpty()) {
            layer.getLayerManager().fireGeometryModified(modifiedFeatures, layer, modifiedFeaturesOldClones);
        }
    }

    public int size() {
        return this.features.size();
    }

    public Feature getFeature(int i) {
        return (Feature)this.features.get(i);
    }

    public void createFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        this.features.add(feature);
        this.originalGeometries.add(new Point(null, null, 0));
        this.proposedGeometries.add(feature.getGeometry().clone());
    }

    public void deleteFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        this.features.add(feature);
        this.originalGeometries.add(feature.getGeometry().clone());
        this.proposedGeometries.add(new Point(null, null, 0));
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static int emptyGeometryCount(Collection transactions) {
        int count = 0;
        for (EditTransaction transaction : transactions) {
            count += transaction.getEmptyGeometryCount();
        }
        return count;
    }

    private int getEmptyGeometryCount() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getGeometry(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static interface SuccessAction {
        public void run();
    }

    public static interface SelectionEditor {
        public Geometry edit(Geometry var1, Collection var2);
    }
}

