/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.Task;
import org.locationtech.jts.jump.workbench.ui.AttributeTab;
import org.locationtech.jts.jump.workbench.ui.GeometryInfoTab;
import org.locationtech.jts.jump.workbench.ui.InfoModel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.TaskFrameProxy;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.util.Assert;

public class InfoFrame
extends JInternalFrame
implements LayerManagerProxy,
SelectionManagerProxy,
LayerNamePanelProxy,
TaskFrameProxy,
LayerViewPanelProxy {
    private LayerManager layerManager;
    private BorderLayout borderLayout1 = new BorderLayout();
    private AttributeTab attributeTab;
    private InfoModel model = new InfoModel();
    private GeometryInfoTab geometryInfoTab;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private WorkbenchFrame workbenchFrame;

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public TaskFrame getTaskFrame() {
        return this.attributeTab.getTaskFrame();
    }

    public InfoFrame(WorkbenchContext workbenchContext, LayerManagerProxy layerManagerProxy, final TaskFrame taskFrame) {
        this.geometryInfoTab = new GeometryInfoTab(this.model, workbenchContext);
        Assert.isTrue((layerManagerProxy.getLayerManager() != null ? 1 : 0) != 0);
        this.layerManager = layerManagerProxy.getLayerManager();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                InfoFrame.this.layerManager = new LayerManager();
            }
        });
        this.attributeTab = new AttributeTab(this.model, workbenchContext, taskFrame, this);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                InfoFrame.this.attributeTab.getToolBar().updateEnabledState();
            }
        });
        this.workbenchFrame = workbenchContext.getWorkbench().getFrame();
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setSize(550, 185);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tabbedPane.addTab("", IconLoader.icon("Table.gif"), this.attributeTab, "Table View");
        this.tabbedPane.addTab("", IconLoader.icon("Paper.gif"), this.geometryInfoTab, "HTML View");
        this.updateTitle(taskFrame.getTask().getName());
        taskFrame.getTask().add(new Task.NameListener(){

            @Override
            public void taskNameChanged(String name) {
                InfoFrame.this.updateTitle(taskFrame.getTask().getName());
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                InfoFrame.this.model.dispose();
            }
        });
    }

    public JPanel getAttributeTab() {
        return this.attributeTab;
    }

    public JPanel getGeometryTab() {
        return this.geometryInfoTab;
    }

    public void setSelectedTab(JPanel tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    public static String title(String taskName) {
        return "Feature Info: " + taskName;
    }

    private void updateTitle(String taskName) {
        this.setTitle(InfoFrame.title(taskName));
    }

    public InfoModel getModel() {
        return this.model;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                try {
                    InfoFrame.this.workbenchFrame.removeInternalFrame(InfoFrame.this);
                }
                catch (Exception x) {
                    InfoFrame.this.workbenchFrame.handleThrowable(x);
                }
            }
        });
        this.setTitle("Feature Info");
        this.getContentPane().setLayout(this.borderLayout1);
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    public void surface() {
        JInternalFrame activeFrame = this.workbenchFrame.getActiveInternalFrame();
        if (!this.workbenchFrame.hasInternalFrame(this)) {
            this.workbenchFrame.addInternalFrame(this, false, true);
        }
        if (activeFrame != null) {
            this.workbenchFrame.activateFrame(activeFrame);
        }
        this.moveToFront();
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.attributeTab.getPanel().getSelectionManager();
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.attributeTab;
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.getTaskFrame().getLayerViewPanel();
    }
}

