/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEventType;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.ui.AbstractSelection;
import org.locationtech.jts.jump.workbench.ui.FeatureSelection;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LineStringSelection;
import org.locationtech.jts.jump.workbench.ui.PartSelection;

public class SelectionManager {
    private FeatureSelection featureSelection;
    private PartSelection partSelection;
    private LineStringSelection lineStringSelection;
    private LayerManagerProxy layerManagerProxy;
    private LayerViewPanel panel;
    private boolean panelUpdatesEnabled = true;
    private LayerListener layerListener = new LayerListener(){

        @Override
        public void featuresChanged(FeatureEvent e) {
            if (e.getType() == FeatureEventType.DELETED) {
                SelectionManager.this.unselectItems(e.getLayer(), e.getFeatures());
            }
            if (e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                SelectionManager.this.unselectFromFeaturesWithModifiedItemCounts(e.getLayer(), e.getFeatures(), e.getOldFeatureClones());
            }
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if (!(e.getLayerable() instanceof Layer)) {
                return;
            }
            if (e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                SelectionManager.this.unselectItems((Layer)e.getLayerable());
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    };
    private List selections;

    public Collection createFeaturesFromSelectedItems() {
        ArrayList newFeatures = new ArrayList();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            newFeatures.addAll(this.createFeaturesFromSelectedItems(layer));
        }
        return newFeatures;
    }

    public Collection createFeaturesFromSelectedItems(Layer layer) {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature feature : this.getFeaturesWithSelectedItems(layer)) {
            for (Geometry item : this.getSelectedItems(layer, feature)) {
                Feature newFeature = (Feature)feature.clone();
                newFeature.setGeometry(item);
                newFeatures.add(newFeature);
            }
        }
        return newFeatures;
    }

    public SelectionManager(LayerViewPanel panel, LayerManagerProxy layerManagerProxy) {
        this.panel = panel;
        this.layerManagerProxy = layerManagerProxy;
        this.featureSelection = new FeatureSelection(this);
        this.lineStringSelection = new LineStringSelection(this);
        this.partSelection = new PartSelection(this);
        this.featureSelection.setParent(null);
        this.featureSelection.setChild(this.partSelection);
        this.partSelection.setParent(this.featureSelection);
        this.partSelection.setChild(this.lineStringSelection);
        this.lineStringSelection.setParent(this.partSelection);
        this.lineStringSelection.setChild(null);
        this.selections = Collections.unmodifiableList(Arrays.asList(this.featureSelection, this.partSelection, this.lineStringSelection));
        this.addLayerListenerTo(layerManagerProxy.getLayerManager());
    }

    private void addLayerListenerTo(LayerManager layerManager) {
        layerManager.addLayerListener(this.layerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems();
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public LineStringSelection getLineStringSelection() {
        return this.lineStringSelection;
    }

    public Collection getSelections() {
        return this.selections;
    }

    public Collection getSelectedItems() {
        ArrayList selectedItems = new ArrayList();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems());
        }
        return selectedItems;
    }

    public Collection getSelectedItems(Layer layer) {
        ArrayList selectedItems = new ArrayList();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer));
        }
        return selectedItems;
    }

    public Collection getSelectedItems(Layer layer, Feature feature) {
        ArrayList selectedItems = new ArrayList();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature));
        }
        return selectedItems;
    }

    public Collection getSelectedItems(Layer layer, Feature feature, Geometry geometry) {
        ArrayList selectedItems = new ArrayList();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature, geometry));
        }
        return selectedItems;
    }

    public Collection getLayersWithSelectedItems() {
        HashSet layersWithSelectedItems = new HashSet();
        for (AbstractSelection selection : this.selections) {
            layersWithSelectedItems.addAll(selection.getLayersWithSelectedItems());
        }
        return layersWithSelectedItems;
    }

    public PartSelection getPartSelection() {
        return this.partSelection;
    }

    public void updatePanel() {
        if (!this.panelUpdatesEnabled) {
            return;
        }
        this.panel.fireSelectionChanged();
        this.panel.getRenderingManager().render("SELECTION_BACKGROUND");
        for (AbstractSelection selection : this.selections) {
            this.panel.getRenderingManager().render(selection.getRendererContentID());
        }
    }

    public void setPanelUpdatesEnabled(boolean panelUpdatesEnabled) {
        this.panelUpdatesEnabled = panelUpdatesEnabled;
    }

    public Collection getFeaturesWithSelectedItems(Layer layer) {
        HashSet featuresWithSelectedItems = new HashSet();
        for (AbstractSelection selection : this.selections) {
            featuresWithSelectedItems.addAll(selection.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Collection features) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer, features);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection features, Collection oldFeatureClones) {
        boolean originalPanelUpdatesEnabled = this.arePanelUpdatesEnabled();
        this.setPanelUpdatesEnabled(false);
        try {
            for (AbstractSelection selection : this.selections) {
                selection.unselectFromFeaturesWithModifiedItemCounts(layer, features, oldFeatureClones);
            }
        }
        finally {
            this.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public Collection getFeaturesWithSelectedItems() {
        ArrayList featuresWithSelectedItems = new ArrayList();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            featuresWithSelectedItems.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    public boolean arePanelUpdatesEnabled() {
        return this.panelUpdatesEnabled;
    }

    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this.layerListener);
    }
}

