/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.LayerTreeModel;
import org.locationtech.jts.jump.workbench.model.Task;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.ui.CloneableInternalFrame;
import org.locationtech.jts.jump.workbench.ui.DummyLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.InfoFrame;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelProxy;
import org.locationtech.jts.jump.workbench.ui.PrimaryInfoFrame;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.jump.workbench.ui.TaskFrameProxy;
import org.locationtech.jts.jump.workbench.ui.TreeLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.DummyTool;
import org.locationtech.jts.jump.workbench.ui.renderer.Renderer;

public class TaskFrame
extends JInternalFrame
implements TaskFrameProxy,
CloneableInternalFrame,
LayerViewPanelProxy,
LayerNamePanelProxy,
LayerManagerProxy,
SelectionManagerProxy,
Task.NameListener {
    BorderLayout borderLayout = new BorderLayout();
    JSplitPane splitPane = new JSplitPane();
    private int cloneIndex;
    private InfoFrame infoFrame = null;
    private LayerNamePanel layerNamePanel = new DummyLayerNamePanel();
    private LayerViewPanel layerViewPanel;
    private Task task;
    private WorkbenchContext workbenchContext;
    private LayerManager layerManager;

    @Override
    public TaskFrame getTaskFrame() {
        return this;
    }

    public TaskFrame(Task task, WorkbenchContext workbenchContext) {
        this(task, 0, workbenchContext);
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.getLayerViewPanel().getSelectionManager();
    }

    private TaskFrame(Task task, int cloneIndex, final WorkbenchContext workbenchContext) {
        this.task = task;
        this.layerManager = task.getLayerManager();
        this.cloneIndex = cloneIndex;
        this.workbenchContext = workbenchContext;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                TaskFrame.this.layerViewPanel.setCurrentCursorTool(new DummyTool());
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                try {
                    TaskFrame.this.layerViewPanel.dispose();
                    TaskFrame.this.layerNamePanel.dispose();
                }
                catch (Throwable t) {
                    workbenchContext.getWorkbench().getFrame().handleThrowable(t);
                }
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                TaskFrame.this.splitPane.remove((Component)((Object)TaskFrame.this.layerNamePanel));
                TaskFrame.this.layerNamePanel = TaskFrame.this.createLayerNamePanel();
                TaskFrame.this.splitPane.add((Component)((Object)TaskFrame.this.layerNamePanel), "left");
                TaskFrame.this.layerNamePanel.addListener(workbenchContext.getWorkbench().getFrame().getLayerNamePanelListener());
            }
        });
        this.layerViewPanel = new LayerViewPanel(task.getLayerManager(), workbenchContext.getWorkbench().getFrame());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.layerViewPanel.addListener(workbenchContext.getWorkbench().getFrame().getLayerViewPanelListener());
        this.layerViewPanel.getViewport().addListener(workbenchContext.getWorkbench().getFrame());
        task.add(this);
        this.installAnimator();
    }

    protected LayerNamePanel createLayerNamePanel() {
        TreeLayerNamePanel treeLayerNamePanel = new TreeLayerNamePanel(this, new LayerTreeModel(this), this.layerViewPanel.getRenderingManager(), new HashMap());
        Map nodeClassToPopupMenuMap = this.workbenchContext.getWorkbench().getFrame().getNodeClassToPopupMenuMap();
        for (Class nodeClass : nodeClassToPopupMenuMap.keySet()) {
            treeLayerNamePanel.addPopupMenu(nodeClass, (JPopupMenu)nodeClassToPopupMenuMap.get(nodeClass));
        }
        return treeLayerNamePanel;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.task.getLayerManager();
    }

    public InfoFrame getInfoFrame() {
        if (this.infoFrame == null || this.infoFrame.isClosed()) {
            this.infoFrame = new PrimaryInfoFrame(this.workbenchContext, this, this);
        }
        return this.infoFrame;
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        return this.layerNamePanel;
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        return this.layerViewPanel;
    }

    public Task getTask() {
        return this.task;
    }

    private int nextCloneIndex() {
        String key = this.getClass().getName() + " - LAST_CLONE_INDEX";
        this.task.getLayerManager().getBlackboard().put(key, 1 + this.task.getLayerManager().getBlackboard().get(key, 0));
        return this.task.getLayerManager().getBlackboard().getInt(key);
    }

    @Override
    public JInternalFrame internalFrameClone() {
        TaskFrame clone = new TaskFrame(this.task, this.nextCloneIndex(), this.workbenchContext);
        clone.splitPane.setDividerLocation(0);
        clone.setSize(300, 300);
        if (this.task.getLayerManager().size() > 0) {
            clone.getLayerViewPanel().getViewport().initialize(this.getLayerViewPanel().getViewport().getScale(), this.getLayerViewPanel().getViewport().getOriginInModelCoordinates());
            clone.getLayerViewPanel().setViewportInitialized(true);
        }
        return clone;
    }

    @Override
    public void taskNameChanged(String name) {
        this.updateTitle();
    }

    private void jbInit() throws Exception {
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setSize(680, 380);
        this.getContentPane().setLayout(this.borderLayout);
        this.splitPane.setBorder(null);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)((Object)this.layerNamePanel), "left");
        this.splitPane.add((Component)this.layerViewPanel, "right");
        this.splitPane.setDividerLocation(200);
        this.updateTitle();
    }

    private void updateTitle() {
        String title = this.task.getName();
        if (this.cloneIndex > 0) {
            title = title + " (View " + (this.cloneIndex + 1) + ")";
        }
        this.setTitle(title);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private void installAnimator() {
        Timer timer = new Timer(500, new ActionListener(){
            private boolean showingClocks = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.wmsRenderingInProgress()) {
                    TaskFrame.this.repaint();
                    this.showingClocks = true;
                } else if (this.showingClocks) {
                    TaskFrame.this.repaint();
                    this.showingClocks = false;
                }
            }

            private boolean wmsRenderingInProgress() {
                for (WMSLayer wmsLayer : TaskFrame.this.layerManager.getLayerables(WMSLayer.class)) {
                    Renderer renderer = TaskFrame.this.layerViewPanel.getRenderingManager().getRenderer(wmsLayer);
                    if (renderer == null || !renderer.isRendering()) continue;
                    return true;
                }
                return false;
            }
        });
        timer.setCoalesce(true);
        timer.start();
    }
}

