/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.geom.EnvelopeUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.ViewportListener;
import org.locationtech.jts.jump.workbench.ui.ZoomHistory;
import org.locationtech.jts.jump.workbench.ui.renderer.java2D.Java2DConverter;

public class Viewport
implements Java2DConverter.PointConverter {
    private static final int INITIAL_VIEW_ORIGIN_X = 0;
    private static final int INITIAL_VIEW_ORIGIN_Y = 0;
    private ArrayList listeners = new ArrayList();
    private Java2DConverter java2DConverter;
    private LayerViewPanel panel;
    private Point2D viewOriginAsPerceivedByModel = new Point2D.Double(0.0, 0.0);
    private double scale = 1.0;
    private AffineTransform modelToViewTransform;
    private ZoomHistory zoomHistory;

    public Viewport(LayerViewPanel panel) {
        this.panel = panel;
        this.zoomHistory = new ZoomHistory(panel);
        this.java2DConverter = new Java2DConverter(this);
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Viewport.this.fireZoomChanged(Viewport.this.getEnvelopeInModelCoordinates());
            }
        });
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }

    public void addListener(ViewportListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ViewportListener l) {
        this.listeners.remove(l);
    }

    public Java2DConverter getJava2DConverter() {
        return this.java2DConverter;
    }

    public ZoomHistory getZoomHistory() {
        return this.zoomHistory;
    }

    public void update() throws NoninvertibleTransformException {
        this.modelToViewTransform = Viewport.modelToViewTransform(this.scale, this.viewOriginAsPerceivedByModel, this.panel.getSize().height);
        this.panel.repaint();
    }

    public static AffineTransform modelToViewTransform(double scale, Point2D viewOriginAsPerceivedByModel, double panelHeight) {
        AffineTransform modelToViewTransform = new AffineTransform();
        modelToViewTransform.translate(0.0, panelHeight);
        modelToViewTransform.scale(1.0, -1.0);
        modelToViewTransform.scale(scale, scale);
        modelToViewTransform.translate(-viewOriginAsPerceivedByModel.getX(), -viewOriginAsPerceivedByModel.getY());
        return modelToViewTransform;
    }

    public double getScale() {
        return this.scale;
    }

    public void initialize(double newScale, Point2D newViewOriginAsPerceivedByModel) {
        this.setScale(newScale);
        this.viewOriginAsPerceivedByModel = newViewOriginAsPerceivedByModel;
    }

    public Point2D getOriginInModelCoordinates() {
        return this.viewOriginAsPerceivedByModel;
    }

    public void zoom(Point2D centreOfNewViewAsPerceivedByOldView, double widthOfNewViewAsPerceivedByOldView, double heightOfNewViewAsPerceivedByOldView) throws NoninvertibleTransformException {
        double zoomFactor = Math.min((double)this.panel.getSize().width / widthOfNewViewAsPerceivedByOldView, (double)this.panel.getSize().height / heightOfNewViewAsPerceivedByOldView);
        double realWidthOfNewViewAsPerceivedByOldView = (double)this.panel.getSize().width / zoomFactor;
        double realHeightOfNewViewAsPerceivedByOldView = (double)this.panel.getSize().height / zoomFactor;
        this.zoom(this.toModelEnvelope(centreOfNewViewAsPerceivedByOldView.getX() - 0.5 * realWidthOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getX() + 0.5 * realWidthOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getY() - 0.5 * realHeightOfNewViewAsPerceivedByOldView, centreOfNewViewAsPerceivedByOldView.getY() + 0.5 * realHeightOfNewViewAsPerceivedByOldView));
    }

    public Point2D toModelPoint(Point2D viewPoint) throws NoninvertibleTransformException {
        return this.getModelToViewTransform().inverseTransform(this.toPoint2DDouble(viewPoint), null);
    }

    private Point2D.Double toPoint2DDouble(Point2D p) {
        if (p instanceof Point2D.Double) {
            return (Point2D.Double)p;
        }
        return new Point2D.Double(p.getX(), p.getY());
    }

    public Coordinate toModelCoordinate(Point2D viewPoint) throws NoninvertibleTransformException {
        return CoordUtil.toCoordinate(this.toModelPoint(viewPoint));
    }

    public Point2D toViewPoint(Point2D modelPoint) throws NoninvertibleTransformException {
        return this.getModelToViewTransform().transform(this.toPoint2DDouble(modelPoint), null);
    }

    @Override
    public Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        Point2D.Double pt = new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
        return this.getModelToViewTransform().transform(pt, pt);
    }

    public Envelope toModelEnvelope(double x1, double x2, double y1, double y2) throws NoninvertibleTransformException {
        Coordinate c1 = this.toModelCoordinate(new Point2D.Double(x1, y1));
        Coordinate c2 = this.toModelCoordinate(new Point2D.Double(x2, y2));
        return new Envelope(c1, c2);
    }

    public AffineTransform getModelToViewTransform() throws NoninvertibleTransformException {
        if (this.modelToViewTransform == null) {
            this.update();
        }
        return this.modelToViewTransform;
    }

    public Envelope getEnvelopeInModelCoordinates() {
        double widthAsPerceivedByModel = (double)this.panel.getWidth() / this.scale;
        double heightAsPerceivedByModel = (double)this.panel.getHeight() / this.scale;
        return new Envelope(this.viewOriginAsPerceivedByModel.getX(), this.viewOriginAsPerceivedByModel.getX() + widthAsPerceivedByModel, this.viewOriginAsPerceivedByModel.getY(), this.viewOriginAsPerceivedByModel.getY() + heightAsPerceivedByModel);
    }

    public void zoom(Envelope modelEnvelope) throws NoninvertibleTransformException {
        if (modelEnvelope.isNull()) {
            return;
        }
        if (!this.zoomHistory.hasNext() && !this.zoomHistory.hasPrev()) {
            this.zoomHistory.add(this.getEnvelopeInModelCoordinates());
        }
        this.setScale(Math.min((double)this.panel.getWidth() / modelEnvelope.getWidth(), (double)this.panel.getHeight() / modelEnvelope.getHeight()));
        double xCenteringOffset = ((double)this.panel.getWidth() / this.scale - modelEnvelope.getWidth()) / 2.0;
        double yCenteringOffset = ((double)this.panel.getHeight() / this.scale - modelEnvelope.getHeight()) / 2.0;
        this.viewOriginAsPerceivedByModel = new Point2D.Double(modelEnvelope.getMinX() - xCenteringOffset, modelEnvelope.getMinY() - yCenteringOffset);
        this.update();
        this.zoomHistory.add(modelEnvelope);
        this.fireZoomChanged(modelEnvelope);
    }

    private void setScale(double scale) {
        this.scale = scale;
    }

    private void fireZoomChanged(Envelope modelEnvelope) {
        for (ViewportListener l : this.listeners) {
            l.zoomChanged(modelEnvelope);
        }
    }

    public void zoomToFullExtent() throws NoninvertibleTransformException {
        this.zoom(this.fullExtent());
    }

    public Envelope fullExtent() {
        return EnvelopeUtil.bufferByFraction(this.panel.getLayerManager().getEnvelopeOfAllLayers(), 0.03);
    }

    public void zoomToViewPoint(Point2D centreOfNewViewAsPerceivedByOldView, double zoomFactor) throws NoninvertibleTransformException {
        double widthOfNewViewAsPerceivedByOldView = (double)this.panel.getWidth() / zoomFactor;
        double heightOfNewViewAsPerceivedByOldView = (double)this.panel.getHeight() / zoomFactor;
        this.zoom(centreOfNewViewAsPerceivedByOldView, widthOfNewViewAsPerceivedByOldView, heightOfNewViewAsPerceivedByOldView);
    }

    public Collection toViewPoints(Collection modelCoordinates) throws NoninvertibleTransformException {
        ArrayList<Point2D> viewPoints = new ArrayList<Point2D>();
        for (Coordinate modelCoordinate : modelCoordinates) {
            viewPoints.add(this.toViewPoint(modelCoordinate));
        }
        return viewPoints;
    }

    public Rectangle2D toViewRectangle(Envelope envelope) throws NoninvertibleTransformException {
        Point2D p1 = this.toViewPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        Point2D p2 = this.toViewPoint(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        return new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
    }
}

