/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.cursortool.AbstractCursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.DelegatingTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.FeatureInfoTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.LeftClickFilter;
import org.locationtech.jts.jump.workbench.ui.cursortool.SelectFeaturesTool;
import org.locationtech.jts.jump.workbench.ui.zoom.PanTool;
import org.locationtech.jts.jump.workbench.ui.zoom.ZoomTool;

public class QuasimodeTool
extends DelegatingTool {
    private Cursor cursor;
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyStateChanged(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyStateChanged(e);
        }

        private void keyStateChanged(KeyEvent e) {
            QuasimodeTool.this.setTool(e);
        }
    };
    private KeyEvent currentKeyEvent = null;
    private LayerViewPanel panel;
    private WorkbenchFrame frame;
    private HashMap keySpecToToolMap = new HashMap();

    public QuasimodeTool(CursorTool defaultTool) {
        super(defaultTool);
        this.add(new ModifierKeySpec(false, false, false), defaultTool);
        this.cursor = defaultTool.getCursor();
    }

    private CursorTool getDefaultTool() {
        return (CursorTool)this.keySpecToToolMap.get(new ModifierKeySpec(false, false, false));
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    private CursorTool getTool(KeyEvent e) {
        CursorTool tool = (CursorTool)this.keySpecToToolMap.get(new ModifierKeySpec(e.isControlDown(), e.isShiftDown(), e.isAltDown() || e.isMetaDown()));
        return tool != null ? tool : this.getDefaultTool();
    }

    private void setTool(KeyEvent e) {
        this.cursor = this.getTool(e).getCursor();
        this.panel.setCursor(this.cursor);
        this.currentKeyEvent = e;
        if (this.getDelegate().isGestureInProgress() && this.getDelegate() != this.getTool(e) && this.getDelegate() != this.getDefaultTool()) {
            this.setDelegate(this.getDefaultTool());
        }
    }

    @Override
    public void activate(final LayerViewPanel panel) {
        super.activate(panel);
        this.panel = panel;
        this.frame = AbstractCursorTool.workbenchFrame(panel);
        if (this.frame != null) {
            this.frame.addEasyKeyListener(this.keyListener);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    super.windowActivated(e);
                    QuasimodeTool.this.setTool(new KeyEvent(panel, 401, 0L, 0, 0, '\uffff'));
                }
            });
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setDelegate(this.currentKeyEvent != null ? this.getTool(this.currentKeyEvent) : this.getDefaultTool());
        super.mousePressed(e);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.frame != null) {
            this.frame.removeEasyKeyListener(this.keyListener);
        }
    }

    public QuasimodeTool add(ModifierKeySpec keySpec, CursorTool tool) {
        if (this.keySpecToToolMap.containsKey(keySpec)) {
            return this;
        }
        this.keySpecToToolMap.put(keySpec, tool != null ? (tool.isRightMouseButtonUsed() ? tool : new LeftClickFilter(tool)) : null);
        return this;
    }

    public static QuasimodeTool addStandardQuasimodes(CursorTool tool) {
        QuasimodeTool quasimodeTool = tool instanceof QuasimodeTool ? (QuasimodeTool)tool : new QuasimodeTool(tool);
        quasimodeTool.add(new ModifierKeySpec(false, false, true), new ZoomTool());
        quasimodeTool.add(new ModifierKeySpec(false, true, true), new PanTool());
        SelectFeaturesTool selectFeaturesTool = new SelectFeaturesTool(){

            @Override
            protected boolean selectedLayersOnly() {
                return false;
            }
        };
        quasimodeTool.add(new ModifierKeySpec(true, false, false), selectFeaturesTool);
        quasimodeTool.add(new ModifierKeySpec(true, true, false), selectFeaturesTool);
        quasimodeTool.add(new ModifierKeySpec(true, false, true), new FeatureInfoTool());
        return quasimodeTool;
    }

    public static class ModifierKeySpec {
        private boolean needsShift;
        private boolean needsAltOrMeta;
        private boolean needsControl;

        public ModifierKeySpec(boolean needsControl, boolean needsShift, boolean needsAltOrMeta) {
            this.needsControl = needsControl;
            this.needsShift = needsShift;
            this.needsAltOrMeta = needsAltOrMeta;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModifierKeySpec)) {
                return false;
            }
            ModifierKeySpec other = (ModifierKeySpec)obj;
            return this.needsControl == other.needsControl && this.needsShift == other.needsShift && this.needsAltOrMeta == other.needsAltOrMeta;
        }
    }
}

