/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.workbench.ui.cursortool.DragTool;

public abstract class RectangleTool
extends DragTool {
    protected Polygon getRectangle() throws NoninvertibleTransformException {
        Envelope e = new Envelope(this.getModelSource().x, this.getModelDestination().x, this.getModelSource().y, this.getModelDestination().y);
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(e.getMinX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMaxY()), new Coordinate(e.getMaxX(), e.getMinY()), new Coordinate(e.getMinX(), e.getMinY())}), null);
    }

    private Collection verticesToSnap(Coordinate source, Coordinate destination) {
        ArrayList<Coordinate> verticesToSnap = new ArrayList<Coordinate>();
        verticesToSnap.add(destination);
        verticesToSnap.add(new Coordinate(source.x, destination.y));
        verticesToSnap.add(new Coordinate(destination.x, source.y));
        return verticesToSnap;
    }

    @Override
    protected void setModelDestination(Coordinate modelDestination) {
        for (Coordinate vertex : this.verticesToSnap(this.getModelSource(), modelDestination)) {
            Coordinate snappedVertex = this.snap(vertex);
            if (!this.getSnapManager().wasSnapCoordinateFound()) continue;
            this.modelDestination = CoordUtil.add(modelDestination, CoordUtil.subtract(snappedVertex, vertex));
            return;
        }
        this.modelDestination = modelDestination;
    }

    @Override
    protected void setModelSource(Coordinate modelSource) {
        this.modelSource = this.snap(modelSource);
    }
}

