/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.geom.EnvelopeUtil;
import org.locationtech.jts.jump.util.CollectionMap;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.AbstractSelection;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.DragTool;

public abstract class SelectTool
extends DragTool {
    private String rendererID;
    protected AbstractSelection selection;

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        if (!this.wasShiftPressed()) {
            this.getPanel().getSelectionManager().clear();
        }
        Map layerToFeaturesInFenceMap = this.getPanel().visibleLayerToFeaturesInFenceMap(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()));
        Set layers = layerToFeaturesInFenceMap.keySet();
        if (this.selectedLayersOnly()) {
            layers.retainAll(Arrays.asList(this.getTaskFrame().getLayerNamePanel().getSelectedLayers()));
        }
        for (Layer layer : layers) {
            if (layer.getName().equals("Fence")) continue;
            boolean originalPanelUpdatesEnabled = this.getPanel().getSelectionManager().arePanelUpdatesEnabled();
            this.getPanel().getSelectionManager().setPanelUpdatesEnabled(false);
            try {
                CollectionMap featureToItemsToSelectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, false);
                CollectionMap featureToItemsToUnselectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, true);
                this.selection.selectItems(layer, featureToItemsToSelectMap);
                if (this.wasShiftPressed()) {
                    this.selection.unselectItems(layer, featureToItemsToUnselectMap);
                }
                this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, true);
            }
            finally {
                this.getPanel().getSelectionManager().setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
            }
        }
        this.getPanel().getSelectionManager().updatePanel();
    }

    protected boolean selectedLayersOnly() {
        return this.wasControlPressed();
    }

    protected SelectTool(String rendererID) {
        this.rendererID = rendererID;
    }

    private CollectionMap featureToItemsInFenceMap(Collection features, Layer layer, boolean selected) throws NoninvertibleTransformException {
        CollectionMap featureToSelectedItemsMap = this.selection.getFeatureToSelectedItemCollectionMap(layer);
        CollectionMap featureToItemsInFenceMap = new CollectionMap();
        for (Feature feature : features) {
            Collection selectedItems = featureToSelectedItemsMap.getItems(feature);
            Collection itemsToReturn = this.itemsInFence(feature);
            if (selected) {
                itemsToReturn.retainAll(selectedItems);
            } else {
                itemsToReturn.removeAll(selectedItems);
            }
            featureToItemsInFenceMap.put(feature, itemsToReturn);
        }
        return featureToItemsInFenceMap;
    }

    private Collection itemsInFence(Feature feature) throws NoninvertibleTransformException {
        ArrayList<Geometry> itemsInFence = new ArrayList<Geometry>();
        Geometry fence = EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates());
        for (Geometry selectedItem : this.selection.items(feature.getGeometry())) {
            if (!LayerViewPanel.intersects(selectedItem, fence)) continue;
            itemsInFence.add(selectedItem);
        }
        return itemsInFence;
    }

    @Override
    public Icon getIcon() {
        return null;
    }
}

