/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.MultiClickTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.operation.valid.IsValidOp;

public class DrawLineStringTool
extends MultiClickTool {
    private FeatureDrawingUtil featureDrawingUtil;

    private DrawLineStringTool(FeatureDrawingUtil featureDrawingUtil) {
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(layerNamePanelProxy);
        return featureDrawingUtil.prepare(new DrawLineStringTool(featureDrawingUtil), true);
    }

    @Override
    public String getName() {
        return "Draw Linestring";
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("DrawLineString.gif");
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkLineString()) {
            return;
        }
        this.execute(this.featureDrawingUtil.createAddCommand((Geometry)this.getLineString(), this.isRollingBackInvalidEdits(), this.getPanel(), this));
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser("The linestring must have at least 2 points");
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

