/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.cursortool.QuasimodeTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.SelectFeaturesTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.SelectLineStringsTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.SelectPartsTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.DeleteVertexTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.DrawLineStringTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.DrawPointTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.DrawPolygonTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.DrawRectangleTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.InsertVertexTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.MoveSelectedItemsTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.MoveVertexTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.SnapVerticesToSelectedVertexTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.SnapVerticesTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.plugin.OptionsPlugIn;
import org.locationtech.jts.jump.workbench.ui.toolbox.ToolboxDialog;
import org.locationtech.jts.jump.workbench.ui.toolbox.ToolboxPlugIn;

public class EditingPlugIn
extends ToolboxPlugIn {
    public static ImageIcon ICON = IconLoader.icon("EditingToolbox.gif");
    public static final String KEY = EditingPlugIn.class.getName();
    private JButton optionsButton = new JButton("Options...");

    @Override
    public String getName() {
        return "Editing Toolbox";
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(KEY, this);
    }

    @Override
    protected void initializeToolbox(ToolboxDialog toolbox) {
        toolbox.setTitle("Editing");
        EnableCheckFactory checkFactory = new EnableCheckFactory(toolbox.getContext());
        toolbox.add(new QuasimodeTool(new SelectFeaturesTool()).add(new QuasimodeTool.ModifierKeySpec(true, false, false), null));
        toolbox.add(new QuasimodeTool(new SelectPartsTool()).add(new QuasimodeTool.ModifierKeySpec(true, false, false), null));
        toolbox.add(new QuasimodeTool(new SelectLineStringsTool()).add(new QuasimodeTool.ModifierKeySpec(true, false, false), null));
        toolbox.add(new MoveSelectedItemsTool(checkFactory));
        toolbox.addToolBar();
        toolbox.add(DrawRectangleTool.create(toolbox.getContext()));
        toolbox.add(DrawPolygonTool.create(toolbox.getContext()));
        toolbox.add(DrawLineStringTool.create(toolbox.getContext()));
        toolbox.add(DrawPointTool.create(toolbox.getContext()));
        toolbox.addToolBar();
        toolbox.add(new InsertVertexTool(checkFactory));
        toolbox.add(new DeleteVertexTool(checkFactory));
        toolbox.add(new MoveVertexTool(checkFactory));
        toolbox.addToolBar();
        toolbox.add(new SnapVerticesTool(checkFactory));
        toolbox.add(new SnapVerticesToSelectedVertexTool(checkFactory));
        this.optionsButton.addActionListener(AbstractPlugIn.toActionListener(new OptionsPlugIn(), toolbox.getContext(), null));
        toolbox.getCenterPanel().add((Component)this.optionsButton, "Center");
        toolbox.setInitialLocation(new GUIUtil.Location(20, true, 20, false));
        toolbox.setResizable(false);
    }

    protected JButton getOptionsButton() {
        return this.optionsButton;
    }
}

