/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.GeometryEditor;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.AbstractCursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.DelegatingTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import org.locationtech.jts.util.Assert;

public class FeatureDrawingUtil {
    private LayerNamePanelProxy layerNamePanelProxy;
    private GeometryEditor editor = new GeometryEditor();

    private Collection selectedFeaturesContaining(Polygon polygon, LayerViewPanel panel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            return new ArrayList();
        }
        ArrayList<Feature> selectedFeaturesContainingPolygon = new ArrayList<Feature>();
        for (Feature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer())) {
            if (feature.getGeometry().getClass() == GeometryCollection.class || !feature.getGeometry().getEnvelopeInternal().contains(polygon.getEnvelopeInternal()) || !feature.getGeometry().contains((Geometry)polygon)) continue;
            selectedFeaturesContainingPolygon.add(feature);
        }
        return selectedFeaturesContainingPolygon;
    }

    private void createHole(Polygon hole, Collection features, Layer layer, LayerViewPanel panel, boolean rollingBackInvalidEdits, String transactionName) {
        Assert.isTrue((hole.getNumInteriorRing() == 0 ? 1 : 0) != 0);
        EditTransaction transaction = new EditTransaction(features, transactionName, layer, rollingBackInvalidEdits, false, panel);
        for (int i = 0; i < transaction.size(); ++i) {
            transaction.setGeometry(i, transaction.getGeometry(i).difference((Geometry)hole));
        }
        transaction.commit();
    }

    public FeatureDrawingUtil(LayerNamePanelProxy layerNamePanelProxy) {
        this.layerNamePanelProxy = layerNamePanelProxy;
    }

    private Layer layer(LayerViewPanel layerViewPanel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            Layer layer = layerViewPanel.getLayerManager().addLayer("Working", "New", AddNewLayerPlugIn.createBlankFeatureCollection());
            layer.setEditable(true);
            layerViewPanel.getContext().warnUser("No layer is editable. Creating new editable layer.");
        }
        return this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer();
    }

    public UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, AbstractCursorTool tool) {
        if (rollingBackInvalidEdits && !geometry.isValid()) {
            layerViewPanel.getContext().warnUser("Draw Feature Tool: Topology error");
            return null;
        }
        layerViewPanel.setViewportInitialized(true);
        final Layer layer = this.layer(layerViewPanel);
        final Feature feature = FeatureUtil.toFeature(this.editor.removeRepeatedPoints(geometry), layer.getFeatureCollectionWrapper().getFeatureSchema());
        return new UndoableCommand(tool.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().add(feature);
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().remove(feature);
            }
        };
    }

    public CursorTool prepare(final AbstractCursorTool drawFeatureTool, boolean allowSnapping) {
        drawFeatureTool.setColor(Color.red);
        if (allowSnapping) {
            drawFeatureTool.allowSnapping();
        }
        return new DelegatingTool(drawFeatureTool){

            @Override
            public String getName() {
                return drawFeatureTool.getName();
            }

            @Override
            public Cursor getCursor() {
                if (Toolkit.getDefaultToolkit().getBestCursorSize(32, 32).equals(new Dimension(0, 0))) {
                    return Cursor.getDefaultCursor();
                }
                return Toolkit.getDefaultToolkit().createCustomCursor(IconLoader.icon("Pen.gif").getImage(), new Point(1, 31), drawFeatureTool.getName());
            }
        };
    }

    public void drawRing(Polygon polygon, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection selectedFeaturesContainingPolygon = this.selectedFeaturesContaining(polygon, panel);
        if (selectedFeaturesContainingPolygon.isEmpty()) {
            AbstractPlugIn.execute(this.createAddCommand((Geometry)polygon, rollingBackInvalidEdits, panel, tool), panel);
        } else {
            this.createHole(polygon, selectedFeaturesContainingPolygon, this.layer(panel), panel, rollingBackInvalidEdits, tool.getName());
        }
    }
}

