/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.ui.cursortool.NClickTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.SnapVerticesOp;
import org.locationtech.jts.util.Assert;

public class SnapVerticesToSelectedVertexClickTool
extends NClickTool {
    private EnableCheckFactory checkFactory;
    private GeometryFactory factory = new GeometryFactory();

    public SnapVerticesToSelectedVertexClickTool(EnableCheckFactory checkFactory) {
        super(1);
        this.checkFactory = checkFactory;
    }

    @Override
    public Icon getIcon() {
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        final Coordinate clickCoordinate = (Coordinate)this.getCoordinates().get(0);
        if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory.createFenceMustBeDrawnCheck())) {
            return;
        }
        if (!this.check(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (!SnapVerticesToSelectedVertexClickTool.this.getPanel().getFence().contains((Geometry)SnapVerticesToSelectedVertexClickTool.this.factory.createPoint(clickCoordinate))) {
                    return "Please click inside the fence.";
                }
                if (SnapVerticesToSelectedVertexClickTool.this.getPanel().getSelectionManager().getSelectedItems().isEmpty()) {
                    return "Select a feature, part, or linestring in the fence containing the vertex to snap to";
                }
                if (SnapVerticesToSelectedVertexClickTool.this.getPanel().getSelectionManager().getSelectedItems().size() > 1) {
                    return "Select only one feature, part, or linestring containing the vertex to snap to";
                }
                return null;
            }
        })) {
            return;
        }
        new SnapVerticesOp().execute(this.getPanel().getFence(), this.getPanel().getLayerManager().getEditableLayers(), this.isRollingBackInvalidEdits(), this.getPanel(), this.getTaskFrame().getTask(), clickCoordinate, (Feature)this.getPanel().getSelectionManager().getFeaturesWithSelectedItems((Layer)this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next()).iterator().next(), this.getWorkbench().getBlackboard().get(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, true));
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }
}

