/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.cursortool.editing;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.ui.cursortool.AbstractCursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.QuasimodeTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.SnapVerticesToSelectedVertexClickTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;

public class SnapVerticesToSelectedVertexTool
extends QuasimodeTool {
    private static final Cursor SHIFT_DOWN_CURSOR = AbstractCursorTool.createCursor(IconLoader.icon("SnapVerticesTogetherCursor3.gif").getImage());
    private static final Cursor SHIFT_NOT_DOWN_CURSOR = AbstractCursorTool.createCursor(IconLoader.icon("SnapVerticesTogetherCursor4.gif").getImage());

    @Override
    public String getName() {
        return AbstractCursorTool.name(this);
    }

    public SnapVerticesToSelectedVertexTool(EnableCheckFactory checkFactory) {
        super(new DrawRectangleFenceTool(){

            @Override
            public void mouseClicked(final MouseEvent e) {
                if (!this.check(new EnableCheck(){

                    @Override
                    public String check(JComponent component) {
                        return !e.isShiftDown() ? "Shift-click the vertex to snap to." : null;
                    }
                })) {
                    return;
                }
                super.mouseClicked(e);
            }

            @Override
            public Cursor getCursor() {
                return SHIFT_NOT_DOWN_CURSOR;
            }
        });
        this.add(new QuasimodeTool.ModifierKeySpec(false, true, false), new SnapVerticesToSelectedVertexClickTool(checkFactory){

            @Override
            public Cursor getCursor() {
                return SHIFT_DOWN_CURSOR;
            }
        });
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("SnapVerticesTogether.gif");
    }
}

