/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.util.Assert;

public class AddNewCategoryPlugIn
extends AbstractPlugIn {
    private static final String NEW_CATEGORY_NAME = "New Category";

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final String categoryName = this.findNewCategoryName(context.getLayerManager());
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                context.getLayerManager().addCategory(categoryName);
            }

            @Override
            public void unexecute() {
                Assert.isTrue((boolean)context.getLayerManager().getCategory(categoryName).isEmpty(), (String)"This can happen when a plug-in calls #reportNothingToUndoYet but adds a layer");
                context.getLayerManager().removeIfEmpty(context.getLayerManager().getCategory(categoryName));
            }
        }, context);
        return true;
    }

    private String findNewCategoryName(LayerManager layerManager) {
        String newName;
        if (layerManager.getCategory(NEW_CATEGORY_NAME) == null) {
            return NEW_CATEGORY_NAME;
        }
        int i = 2;
        do {
            newName = "New Category (" + i + ")";
            ++i;
        } while (layerManager.getCategory(newName) != null);
        return newName;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

