/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;

public class DeleteAllFeaturesPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layer : Arrays.asList(context.getLayerNamePanel().getSelectedLayers())) {
            transactions.add(this.createTransaction(layer, context));
        }
        return EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, PlugInContext context) {
        EditTransaction transaction = new EditTransaction(new ArrayList(), this.getName(), layer, this.isRollingBackInvalidEdits(context), true, context.getWorkbenchFrame());
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            transaction.deleteFeature(feature);
        }
        return transaction;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck());
    }
}

