/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.GeometryEditor;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;

public class DeleteSelectedItemsPlugIn
extends AbstractPlugIn {
    private GeometryEditor geometryEditor = new GeometryEditor();

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

                @Override
                public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                    Geometry g = geometryWithSelectedItems;
                    for (Geometry selectedItem : selectedItems) {
                        g = DeleteSelectedItemsPlugIn.this.geometryEditor.remove(g, selectedItem);
                    }
                    return g;
                }
            }, (SelectionManagerProxy)((Object)context.getActiveInternalFrame()), context.getWorkbenchFrame(), this.getName(), layerWithSelectedItems, this.isRollingBackInvalidEdits(context), true));
        }
        return EditTransaction.commit(transactions);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.registerDeleteKey(context.getWorkbenchContext());
    }

    private void registerDeleteKey(WorkbenchContext context) {
        context.getWorkbench().getFrame().addKeyboardShortcut(127, 0, this, DeleteSelectedItemsPlugIn.createEnableCheck(context));
    }
}

