/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.Arrays;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.WorkbenchException;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.EnterWKTDialog;
import org.locationtech.jts.jump.workbench.ui.plugin.WKTDisplayHelper;
import org.locationtech.jts.jump.workbench.ui.plugin.WKTPlugIn;

public class EditSelectedFeaturePlugIn
extends WKTPlugIn {
    private Feature feature;
    private WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    protected Layer layer(PlugInContext context) {
        return (Layer)context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    @Override
    public String getName() {
        return "View / Edit Selected Feature";
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return this.execute(context, (Feature)context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator().next(), true);
    }

    public boolean execute(PlugInContext context, Feature feature, boolean editable) throws Exception {
        this.feature = feature;
        this.reportNothingToUndoYet(context);
        return super.execute(context);
    }

    @Override
    protected void apply(String wkt, PlugInContext context) throws Exception {
        if (!this.layer(context).isEditable()) {
            return;
        }
        super.apply(wkt, context);
    }

    @Override
    protected void apply(FeatureCollection c, PlugInContext context) throws WorkbenchException {
        if (c.size() != 1) {
            throw new WorkbenchException("Expected 1 feature but found " + c.size());
        }
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.feature), this.getName(), this.layer, this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        transaction.setGeometry(0, ((Feature)c.iterator().next()).getGeometry());
        transaction.commit();
    }

    @Override
    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle((this.layer(context).isEditable() ? "Edit " : "") + "Feature " + this.feature.getID() + " In " + this.layer + (this.layer(context).isEditable() ? "" : " (layer is uneditable)"));
        d.setEditable(this.layer(context).isEditable());
        d.setText(this.helper.format(this.feature.getGeometry().toString()));
        return d;
    }
}

