/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.locationtech.jts.jump.util.CollectionUtil;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.ui.plugin.MenuItemShownListener;
import org.locationtech.jts.jump.workbench.ui.task.TaskMonitorManager;
import org.locationtech.jts.util.Assert;

public class FeatureInstaller {
    private WorkbenchContext workbenchContext;
    private TaskMonitorManager taskMonitorManager = new TaskMonitorManager();
    private EnableCheckFactory checkFactory;

    public FeatureInstaller(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.checkFactory = new EnableCheckFactory(workbenchContext);
    }

    public MultiEnableCheck createLayersSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createOneLayerSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createVectorsExistCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNVectorsMustBeDrawnCheck(1));
    }

    public MultiEnableCheck createFenceExistsCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createFenceMustBeDrawnCheck());
    }

    public void addMenuSeparator(String menu) {
        this.addMenuSeparator(new String[]{menu});
    }

    public void addMenuSeparator(String[] menuPath) {
        JMenu mainMenu = this.menuBarMenu(menuPath[0]);
        this.addMenuSeparator(this.createMenusIfNecessary(mainMenu, this.behead(menuPath)));
    }

    public void addMenuSeparator(JMenu menu) {
        Component separator = null;
        Component exitMenu = null;
        if (menu.getText().equals("File")) {
            separator = menu.getMenuComponent(menu.getMenuComponentCount() - 2);
            exitMenu = menu.getMenuComponent(menu.getMenuComponentCount() - 1);
            menu.remove(separator);
            menu.remove(exitMenu);
        }
        menu.addSeparator();
        if (menu.getText().equals("File")) {
            menu.add(separator);
            menu.add(exitMenu);
        }
    }

    private void associate(JMenuItem menuItem, PlugIn plugIn) {
        menuItem.addActionListener(AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, this.taskMonitorManager));
    }

    private String[] behead(String[] a1) {
        String[] a2 = new String[a1.length - 1];
        System.arraycopy(a1, 1, a2, 0, a2.length);
        return a2;
    }

    public void addMainMenuItem(PlugIn executable, String menuName, String menuItemName, Icon icon, EnableCheck enableCheck) {
        this.addMainMenuItem(executable, new String[]{menuName}, menuItemName, false, icon, enableCheck);
    }

    public void addLayerViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerNameViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()));
    }

    public void addMainMenuItem(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = this.removeProperties(menuItemName);
        JMenu menu = this.menuBarMenu(menuPath[0]);
        if (menu == null) {
            menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), this.menuBar());
            this.addToMenuBar(menu);
        }
        JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), parent);
        menuItem.setIcon(icon);
        this.associate(menuItem, executable);
        if (properties.get("pos") != null) {
            parent.insert(menuItem, Integer.parseInt((String)properties.get("pos")));
        } else if (parent.getText().equals("File") && parent == menu) {
            menu.insert(menuItem, menu.getItemCount() - 2);
        } else {
            parent.add(menuItem);
        }
        if (enableCheck != null) {
            this.addMenuItemShownListener(menuItem, this.toMenuItemShownListener(enableCheck));
        }
    }

    private Map extractProperties(String menuItemName) {
        if (menuItemName.indexOf(123) == -1) {
            return new HashMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String s = menuItemName.substring(menuItemName.indexOf(123) + 1, menuItemName.indexOf(125));
        for (String property : StringUtil.fromCommaDelimitedString(s)) {
            properties.put(property.substring(0, property.indexOf(58)).trim(), property.substring(property.indexOf(58) + 1, property.length()).trim());
        }
        return properties;
    }

    private String removeProperties(String menuItemName) {
        return menuItemName.indexOf(123) > -1 ? menuItemName.substring(0, menuItemName.indexOf(123)) : menuItemName;
    }

    public static JMenuItem installMnemonic(JMenuItem menuItem, MenuElement parent) {
        String text = menuItem.getText();
        StringUtil.replaceAll(text, "&&", "##");
        int ampersandPosition = text.indexOf(38);
        if (-1 < ampersandPosition && ampersandPosition + 1 < text.length()) {
            menuItem.setMnemonic(text.charAt(ampersandPosition + 1));
            text = StringUtil.replace(text, "&", "", false);
        } else {
            FeatureInstaller.installDefaultMnemonic(menuItem, parent);
        }
        StringUtil.replaceAll(text, "##", "&");
        menuItem.setText(text);
        return menuItem;
    }

    private static void installDefaultMnemonic(JMenuItem menuItem, MenuElement parent) {
        block0: for (int i = 0; i < menuItem.getText().length(); ++i) {
            char candidate = Character.toUpperCase(menuItem.getText().charAt(i));
            if (!Character.isLetter(candidate)) continue;
            for (JMenuItem other : FeatureInstaller.menuItems(parent)) {
                if (other.getMnemonic() != candidate) continue;
                continue block0;
            }
            menuItem.setMnemonic(candidate);
            return;
        }
        menuItem.setMnemonic(menuItem.getText().charAt(0));
    }

    private static Collection menuItems(MenuElement element) {
        ArrayList<MenuElement> menuItems = new ArrayList<MenuElement>();
        if (element instanceof JMenuBar) {
            for (int i = 0; i < ((JMenuBar)element).getMenuCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenuBar)element).getMenu(i), menuItems);
            }
        } else if (element instanceof JMenu) {
            for (int i = 0; i < ((JMenu)element).getItemCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenu)element).getItem(i), menuItems);
            }
        } else if (element instanceof JPopupMenu) {
            MenuElement[] children = ((JPopupMenu)element).getSubElements();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof JMenuItem)) continue;
                menuItems.add(children[i]);
            }
        } else {
            Assert.shouldNeverReachHere((String)element.getClass().getName());
        }
        return menuItems;
    }

    private MenuItemShownListener toMenuItemShownListener(final EnableCheck enableCheck) {
        return new MenuItemShownListener(){

            @Override
            public void menuItemShown(JMenuItem menuItem) {
                String errorMessage = null;
                try {
                    errorMessage = enableCheck.check(menuItem);
                }
                catch (Exception e) {
                    System.out.println(menuItem.getText());
                    FeatureInstaller.this.workbenchContext.getWorkbench().getFrame().handleThrowable(e);
                }
                if (errorMessage != null) {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText(errorMessage);
                    return;
                }
                menuItem.setEnabled(true);
                menuItem.setToolTipText(null);
            }
        };
    }

    private JMenu createMenusIfNecessary(JMenu parent, String[] menuPath) {
        if (menuPath.length == 0) {
            return parent;
        }
        JMenu child = (JMenu)FeatureInstaller.childMenuItem(menuPath[0], parent);
        if (child == null) {
            child = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), parent);
            parent.add(child);
        }
        return this.createMenusIfNecessary(child, this.behead(menuPath));
    }

    public void addMenuItemShownListener(final JMenuItem menuItem, final MenuItemShownListener menuItemShownListener) {
        JMenu menu = (JMenu)((JPopupMenu)menuItem.getParent()).getInvoker();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menuItemShownListener.menuItemShown(menuItem);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), popupMenu);
        menuItem.setIcon(icon);
        this.addPopupMenuItem(popupMenu, executable, menuItem, enableCheck);
    }

    private void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, final JMenuItem menuItem, final EnableCheck enableCheck) {
        this.associate(menuItem, executable);
        popupMenu.add(menuItem);
        if (enableCheck != null) {
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    FeatureInstaller.this.toMenuItemShownListener(enableCheck).menuItemShown(menuItem);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    public JMenuBar menuBar() {
        return this.workbenchContext.getWorkbench().getFrame().getJMenuBar();
    }

    public JMenu menuBarMenu(String childName) {
        MenuElement[] subElements = this.menuBar().getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            JMenuItem menuItem;
            if (!(subElements[i] instanceof JMenuItem) || !(menuItem = (JMenuItem)subElements[i]).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    private void addToMenuBar(JMenu menu) {
        this.menuBar().add(menu);
        JMenu windowMenu = this.menuBarMenu("Window");
        JMenu helpMenu = this.menuBarMenu("Help");
        if (windowMenu != null) {
            this.menuBar().remove(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().remove(helpMenu);
        }
        if (windowMenu != null) {
            this.menuBar().add(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().add(helpMenu);
        }
    }

    public static JMenuItem childMenuItem(String childName, MenuElement menu) {
        if (menu instanceof JMenu) {
            return FeatureInstaller.childMenuItem(childName, ((JMenu)menu).getPopupMenu());
        }
        MenuElement[] childMenuItems = menu.getSubElements();
        for (int i = 0; i < childMenuItems.length; ++i) {
            if (!(childMenuItems[i] instanceof JMenuItem) || !((JMenuItem)childMenuItems[i]).getText().equals(childName)) continue;
            return (JMenuItem)childMenuItems[i];
        }
        return null;
    }
}

