/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;

public class FeatureStatisticsPlugIn
extends AbstractPlugIn {
    public static final String nPtsAttr = "nPts";
    public static final String nHolesAttr = "nHoles";
    public static final String nCompsAttr = "nComponents";
    public static final String areaAttr = "area";
    public static final String lengthAttr = "length";
    public static final String typeAttr = "type";
    private static final String jtsGeometryClassPackagePrefix = "org.locationtech.jts.geom";

    public static FeatureSchema getStatisticsSchema() {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute(nPtsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nHolesAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(nCompsAttr, AttributeType.INTEGER);
        featureSchema.addAttribute(areaAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(lengthAttr, AttributeType.DOUBLE);
        featureSchema.addAttribute(typeAttr, AttributeType.STRING);
        return featureSchema;
    }

    public static String removeGeometryPackage(String fullClassName) {
        if (fullClassName.startsWith(jtsGeometryClassPackagePrefix)) {
            return StringUtil.classNameWithoutQualifiers(fullClassName);
        }
        return fullClassName;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            this.featureStatistics(selectedLayers[i], context);
        }
        return true;
    }

    private void featureStatistics(Layer layer, PlugInContext context) {
        FeatureSchema statsSchema = FeatureStatisticsPlugIn.getStatisticsSchema();
        FeatureDataset statsFC = new FeatureDataset(statsSchema);
        Iterator i = layer.getFeatureCollectionWrapper().iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry g = f.getGeometry();
            double area = g.getArea();
            double length = g.getLength();
            int comps = 1;
            if (g instanceof GeometryCollection) {
                comps = ((GeometryCollection)g).getNumGeometries();
            }
            Coordinate[] pts = g.getCoordinates();
            int holes = 0;
            if (g instanceof Polygon) {
                holes = ((Polygon)g).getNumInteriorRing();
            }
            BasicFeature statsf = new BasicFeature(statsSchema);
            statsf.setAttribute("GEOMETRY", (Object)g);
            statsf.setAttribute(nPtsAttr, (Object)new Integer(pts.length));
            statsf.setAttribute(nHolesAttr, (Object)new Integer(holes));
            statsf.setAttribute(nCompsAttr, (Object)new Integer(comps));
            statsf.setAttribute(areaAttr, (Object)new Double(area));
            statsf.setAttribute(lengthAttr, (Object)new Double(length));
            statsf.setAttribute(typeAttr, (Object)FeatureStatisticsPlugIn.removeGeometryPackage(g.getClass().getName()));
            statsFC.add(statsf);
        }
        Layer statsLayer = context.addLayer("QA", "Statistics-" + layer.getName(), statsFC);
        statsLayer.setStyles(layer.cloneStyles());
    }
}

