/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;
import org.locationtech.jts.jump.coordsys.CoordinateSystemRegistry;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.datasource.Connection;
import org.locationtech.jts.jump.io.datasource.DataSource;
import org.locationtech.jts.jump.task.TaskMonitor;
import org.locationtech.jts.jump.util.java2xml.XML2Java;
import org.locationtech.jts.jump.workbench.model.Category;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.Task;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.plugin.ThreadedBasePlugIn;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.plugin.SaveProjectAsPlugIn;

public class OpenProjectPlugIn
extends ThreadedBasePlugIn {
    private JFileChooser fileChooser;

    @Override
    public String getName() {
        return "Open Task";
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle("Open Task");
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(SaveProjectAsPlugIn.JUMP_PROJECT_FILE_FILTER);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        return 0 == this.fileChooser.showOpenDialog(context.getWorkbenchFrame());
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.open(this.fileChooser.getSelectedFile(), context.getWorkbenchFrame(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File file, WorkbenchFrame workbenchFrame, TaskMonitor monitor) throws Exception {
        monitor.report("Creating objects");
        try (FileReader reader = new FileReader(file);){
            Task sourceTask = (Task)new XML2Java().read(reader, Task.class);
            Task newTask = new Task();
            newTask.setName(GUIUtil.nameWithoutExtension(file));
            newTask.setProjectFile(file);
            workbenchFrame.addTaskFrame(newTask);
            this.loadLayers(sourceTask.getLayerManager(), newTask.getLayerManager(), CoordinateSystemRegistry.instance(workbenchFrame.getContext().getBlackboard()), monitor);
        }
    }

    private void loadLayers(LayerManager sourceLayerManager, LayerManager newLayerManager, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        for (Category sourceLayerCategory : sourceLayerManager.getCategories()) {
            newLayerManager.addCategory(sourceLayerCategory.getName());
            ArrayList layerables = new ArrayList(sourceLayerCategory.getLayerables());
            Collections.reverse(layerables);
            for (Layerable layerable : layerables) {
                monitor.report("Loading " + layerable.getName());
                layerable.setLayerManager(newLayerManager);
                if (layerable instanceof Layer) {
                    Layer layer = (Layer)layerable;
                    layer.setFeatureCollection(this.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
                    layer.setFeatureCollectionModified(false);
                }
                newLayerManager.addLayerable(sourceLayerCategory.getName(), layerable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        try (Connection connection = dataSource.getConnection();){
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
    }
}

