/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.locationtech.jts.jump.util.OrderedMap;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Category;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.util.Assert;

public class RemoveSelectedCategoriesPlugIn
extends AbstractPlugIn {
    private Category pickUnselectedCategory(LayerNamePanel layerNamePanel, LayerManager layerManager) {
        Collection selectedCategories = layerNamePanel.getSelectedCategories();
        Category workingCategory = layerManager.getCategory("Working");
        if (workingCategory != null && !selectedCategories.contains(workingCategory)) {
            return workingCategory;
        }
        for (Category category : layerManager.getCategories()) {
            if (selectedCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.execute(this.toCategorySpecToLayerablesMap(this.toOrderedCategories(context.getLayerNamePanel().getSelectedCategories())), this.pickUnselectedCategory(context.getLayerNamePanel(), context.getLayerManager()), context);
        return true;
    }

    private List toOrderedCategories(Collection unorderedCategories) {
        ArrayList orderedCategories = new ArrayList(unorderedCategories);
        Collections.sort(orderedCategories, new Comparator(){

            public int compare(Object o1, Object o2) {
                Category c1 = (Category)o1;
                Category c2 = (Category)o2;
                return new Integer(c1.getLayerManager().indexOf(c1)).compareTo(new Integer(c2.getLayerManager().indexOf(c2)));
            }
        });
        return orderedCategories;
    }

    private OrderedMap toCategorySpecToLayerablesMap(List selectedCategoriesInOrder) {
        OrderedMap map = new OrderedMap();
        for (Category category : selectedCategoriesInOrder) {
            map.put(new CategorySpec(category.getName(), category.getLayerManager().indexOf(category)), new ArrayList(category.getLayerables()));
        }
        return map;
    }

    private void execute(final OrderedMap originalCategorySpecToLayerablesMap, final Category newCategory, final PlugInContext context) throws Exception {
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                for (CategorySpec originalCategorySpec : originalCategorySpecToLayerablesMap.keyList()) {
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    for (Layerable layerable : layers) {
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(newCategory.getName(), layerable);
                    }
                    context.getLayerManager().removeIfEmpty(context.getLayerManager().getCategory(originalCategorySpec.name));
                }
            }

            @Override
            public void unexecute() {
                for (CategorySpec originalCategorySpec : originalCategorySpecToLayerablesMap.keyList()) {
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    Assert.isTrue((null == context.getLayerManager().getCategory(originalCategorySpec.name) ? 1 : 0) != 0);
                    context.getLayerManager().addCategory(originalCategorySpec.name, originalCategorySpec.index);
                    for (Layerable layerable : layers) {
                        Assert.isTrue((context.getLayerManager().getCategory(layerable) == newCategory ? 1 : 0) != 0);
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(originalCategorySpec.name, layerable);
                    }
                }
            }
        }, context);
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return RemoveSelectedCategoriesPlugIn.this.pickUnselectedCategory(workbenchContext.getLayerNamePanel(), workbenchContext.getLayerManager()) == null ? "At least 1 category must be left unselected" : null;
            }
        });
    }

    private static class CategorySpec {
        private int index;
        private String name;

        public CategorySpec(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

