/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import org.locationtech.jts.jump.task.TaskMonitor;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.driver.AbstractOutputDriver;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.plugin.ThreadedBasePlugIn;
import org.locationtech.jts.jump.workbench.ui.DriverDialog;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;

public class SaveDatasetAsPlugIn
extends ThreadedBasePlugIn {
    private DriverDialog saveDatasetDialog;
    private Layer layer;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.saveDatasetDialog = new DriverDialog(context.getWorkbenchFrame(), "Save Dataset", true);
        this.saveDatasetDialog.initialize(context.getDriverManager().getOutputDrivers());
        GUIUtil.centreOnWindow(this.saveDatasetDialog);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    @Override
    public String getName() {
        return "Save Dataset As (old)";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.layer = context.getSelectedLayer(0);
        this.saveDatasetDialog.setLayer(this.layer);
        this.saveDatasetDialog.setVisible(true);
        return this.saveDatasetDialog.wasOKPressed();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (!this.saveDatasetDialog.wasOKPressed()) {
            return;
        }
        AbstractOutputDriver outputDriver = (AbstractOutputDriver)this.saveDatasetDialog.getCurrentDriver();
        monitor.report("Saving " + this.layer.getName() + "...");
        outputDriver.output(this.layer);
    }
}

