/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.FenceLayerFinder;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;

public class SelectFeaturesInFencePlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        context.getLayerViewPanel().getSelectionManager().clear();
        SelectFeaturesInFencePlugIn.execute(context.getLayerViewPanel(), context.getLayerNamePanel(), context.getLayerViewPanel().getFence(), true, false);
        return true;
    }

    public static void execute(LayerViewPanel layerViewPanel, LayerNamePanel layerNamePanel, Geometry fence, boolean skipUnselectedLayers, boolean mentionModifierHelp) {
        List<Layer> selectedLayers = Arrays.asList(layerNamePanel.getSelectedLayers());
        Map layerToFeaturesInFenceMap = layerViewPanel.visibleLayerToFeaturesInFenceMap(fence);
        for (Layer layer : layerToFeaturesInFenceMap.keySet()) {
            if (layer == new FenceLayerFinder(layerViewPanel).getLayer() || skipUnselectedLayers && !selectedLayers.contains(layer)) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, (Collection)layerToFeaturesInFenceMap.get(layer));
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }
}

