/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.io.IOException;
import java.io.InputStream;
import org.locationtech.jts.jump.util.FileUtil;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.HTMLFrame;
import org.locationtech.jts.util.Assert;

public class ShortcutKeysPlugIn
extends AbstractPlugIn {
    private static String html = null;

    private HTMLFrame frame(WorkbenchContext context) {
        String key = this.getClass().getName() + " - Frame";
        if (context.getWorkbench().getBlackboard().get(key) == null) {
            HTMLFrame frame = new HTMLFrame(context.getWorkbench().getFrame());
            frame.setRecordNavigationControlVisible(false);
            frame.createNewDocument();
            try {
                this.append(frame);
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere();
            }
            frame.setTitle("Shortcut Keys");
            frame.setSize(420, 290);
            context.getWorkbench().getBlackboard().put(key, frame);
        }
        return (HTMLFrame)context.getWorkbench().getBlackboard().get(key);
    }

    public static String html() throws IOException {
        if (html == null) {
            html = "";
            try (InputStream inputStream = ShortcutKeysPlugIn.class.getResourceAsStream("KeyboardPlugIn.html");){
                for (String line : FileUtil.getContents(inputStream)) {
                    html = html + line;
                }
            }
        }
        return html;
    }

    private void append(HTMLFrame frame) throws IOException {
        frame.append(this.removeHTMLTags(ShortcutKeysPlugIn.html()));
    }

    private String removeHTMLTags(String s) {
        return StringUtil.replaceAll(StringUtil.replaceAll(s, "<html>", ""), "</html>", "");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.frame(context.getWorkbenchContext()).surface();
        return true;
    }
}

