/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.util.FlexibleDateParser;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelListener;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelProxy;
import org.locationtech.jts.jump.workbench.ui.SchemaPanel;
import org.locationtech.jts.jump.workbench.ui.TreeLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.util.Assert;

public class ViewSchemaPlugIn
extends AbstractPlugIn {
    private static final String KEY = ViewSchemaPlugIn.class + " - FRAME";
    private EditingPlugIn editingPlugIn;
    private GeometryFactory factory = new GeometryFactory();
    private WKTReader wktReader = new WKTReader(this.factory);
    private FlexibleDateParser dateParser = new FlexibleDateParser();
    private DateFormat dateFormatter = DateFormat.getDateInstance();
    public static final ImageIcon ICON = IconLoader.icon("Object.gif");

    public ViewSchemaPlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }

    @Override
    public String getName() {
        return "View / Edit Schema";
    }

    private void applyChanges(Layer layer, SchemaPanel panel) throws Exception {
        if (!panel.isModified()) {
            return;
        }
        if (panel.validateInput() != null) {
            throw new Exception(panel.validateInput());
        }
        panel.getModel().removeBlankRows();
        FeatureSchema newSchema = new FeatureSchema();
        for (int i = 0; i < panel.getModel().getRowCount(); ++i) {
            newSchema.addAttribute(panel.getModel().get(i).getName(), panel.getModel().get(i).getType());
        }
        List originalFeatures = layer.getFeatureCollectionWrapper().getFeatures();
        ArrayList<Feature> tempFeatures = new ArrayList<Feature>();
        Iterator i = layer.getFeatureCollectionWrapper().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            tempFeatures.add(this.convert(feature, panel, newSchema));
        }
        for (int i2 = 0; i2 < originalFeatures.size(); ++i2) {
            Feature originalFeature = (Feature)originalFeatures.get(i2);
            Feature tempFeature = (Feature)tempFeatures.get(i2);
            originalFeature.setSchema(tempFeature.getSchema());
            originalFeature.setAttributes(tempFeature.getAttributes());
        }
        layer.getLayerManager().getUndoableEditReceiver().getUndoManager().discardAllEdits();
        layer.setFeatureCollection(new FeatureDataset(originalFeatures, newSchema));
        layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        panel.markAsUnmodified();
    }

    private Feature convert(Feature oldFeature, SchemaPanel panel, FeatureSchema newSchema) throws ConversionException {
        BasicFeature newFeature = new BasicFeature(newSchema);
        for (int i = 0; i < panel.getModel().getRowCount(); ++i) {
            if (panel.getModel().get(i).getOriginalIndex() == -1) {
                newFeature.setAttribute(i, (Object)(panel.getModel().get(i).getType() == AttributeType.GEOMETRY ? oldFeature.getGeometry() : null));
                continue;
            }
            newFeature.setAttribute(i, this.convert(oldFeature.getAttribute(panel.getModel().get(i).getOriginalIndex()), oldFeature.getSchema().getAttributeType(panel.getModel().get(i).getOriginalIndex()), newFeature.getSchema().getAttributeType(i), panel.getModel().get(i).getName(), panel.isForcingInvalidConversionsToNull()));
        }
        return newFeature;
    }

    private String limitLength(String s) {
        return StringUtil.limitLength(s, 30);
    }

    private Object convert(Object oldValue, AttributeType oldType, AttributeType newType, String name, boolean forcingInvalidConversionsToNull) throws ConversionException {
        try {
            if (oldValue == null) {
                return newType == AttributeType.GEOMETRY ? this.factory.createPoint((Coordinate)null) : null;
            }
            if (oldType == AttributeType.STRING) {
                String oldString = (String)oldValue;
                if (newType == AttributeType.STRING) {
                    return oldString;
                }
                if (newType == AttributeType.INTEGER) {
                    try {
                        return new Integer(oldString);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("Cannot convert to integer: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.DOUBLE) {
                    try {
                        return new Double(oldString);
                    }
                    catch (NumberFormatException e) {
                        throw new ConversionException("Cannot convert to double: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.GEOMETRY) {
                    try {
                        return this.wktReader.read(oldString);
                    }
                    catch (org.locationtech.jts.io.ParseException e) {
                        throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
                if (newType == AttributeType.DATE) {
                    try {
                        return this.dateParser.parse(oldString, false);
                    }
                    catch (ParseException e) {
                        throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
            }
            if (oldType == AttributeType.INTEGER) {
                int oldInt = (Integer)oldValue;
                if (newType == AttributeType.STRING) {
                    return "" + oldInt;
                }
                if (newType == AttributeType.INTEGER) {
                    return oldValue;
                }
                if (newType == AttributeType.DOUBLE) {
                    return new Double(oldInt);
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    try {
                        return this.dateParser.parse("" + oldInt, false);
                    }
                    catch (ParseException e) {
                        throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                    }
                }
            }
            if (oldType == AttributeType.DOUBLE) {
                double oldDouble = (Double)oldValue;
                if (newType == AttributeType.STRING) {
                    return "" + oldDouble;
                }
                if (newType == AttributeType.INTEGER) {
                    return new Integer((int)oldDouble);
                }
                if (newType == AttributeType.DOUBLE) {
                    return oldValue;
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
            }
            if (oldType == AttributeType.GEOMETRY) {
                Geometry oldGeometry = (Geometry)oldValue;
                if (newType == AttributeType.STRING) {
                    return oldGeometry.toString();
                }
                if (newType == AttributeType.INTEGER) {
                    throw new ConversionException("Cannot convert to integer: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DOUBLE) {
                    throw new ConversionException("Cannot convert to double: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.GEOMETRY) {
                    return oldGeometry;
                }
                if (newType == AttributeType.DATE) {
                    throw new ConversionException("Cannot convert to date: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
            }
            if (oldType == AttributeType.DATE) {
                Date oldDate = (Date)oldValue;
                if (newType == AttributeType.STRING) {
                    return this.dateFormatter.format(oldDate);
                }
                if (newType == AttributeType.INTEGER) {
                    return new Integer((int)oldDate.getTime());
                }
                if (newType == AttributeType.DOUBLE) {
                    return new Double(oldDate.getTime());
                }
                if (newType == AttributeType.GEOMETRY) {
                    throw new ConversionException("Cannot convert to geometry: \"" + this.limitLength(oldValue.toString()) + "\" (" + name + ")");
                }
                if (newType == AttributeType.DATE) {
                    return oldValue;
                }
            }
            Assert.shouldNeverReachHere((String)newType.toString());
            return null;
        }
        catch (ConversionException e) {
            if (forcingInvalidConversionsToNull) {
                return newType == AttributeType.GEOMETRY ? this.factory.createPoint((Coordinate)null) : null;
            }
            throw e;
        }
    }

    private void commitEditsInProgress(SchemaPanel panel) {
        if (panel.getTable().getEditingRow() != -1) {
            panel.getTable().getCellEditor(panel.getTable().getEditingRow(), panel.getTable().getEditingColumn()).stopCellEditing();
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (this.frame(context) == null) {
            context.getSelectedLayer(0).getBlackboard().put(KEY, new EditSchemaFrame(context.getWorkbenchFrame(), context.getSelectedLayer(0), this.editingPlugIn));
        }
        this.frame(context).surface();
        return true;
    }

    private EditSchemaFrame frame(PlugInContext context) {
        return (EditSchemaFrame)context.getSelectedLayer(0).getBlackboard().get(KEY);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    private class EditSchemaFrame
    extends JInternalFrame
    implements LayerNamePanelProxy,
    LayerNamePanel,
    LayerManagerProxy {
        private LayerManager layerManager;
        private Layer layer;
        private WorkbenchFrame workbenchFrame;

        public EditSchemaFrame(final WorkbenchFrame workbenchFrame, final Layer layer, EditingPlugIn editingPlugIn) {
            this.layer = layer;
            this.workbenchFrame = workbenchFrame;
            layer.getBlackboard().put(KEY, this);
            this.layerManager = layer.getLayerManager();
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    layer.getBlackboard().put(KEY, null);
                }
            });
            final SchemaPanel panel = new SchemaPanel(layer, editingPlugIn, workbenchFrame.getContext());
            this.setResizable(true);
            this.setClosable(true);
            this.setMaximizable(true);
            this.setIconifiable(true);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "Center");
            this.setSize(500, 300);
            this.updateTitle(layer);
            layer.getLayerManager().addLayerListener(new LayerListener(){

                @Override
                public void categoryChanged(CategoryEvent e) {
                }

                @Override
                public void featuresChanged(FeatureEvent e) {
                }

                @Override
                public void layerChanged(LayerEvent e) {
                    EditSchemaFrame.this.updateTitle(layer);
                }
            });
            this.setDefaultCloseOperation(0);
            panel.add(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ViewSchemaPlugIn.this.commitEditsInProgress(panel);
                        ViewSchemaPlugIn.this.applyChanges(layer, panel);
                    }
                    catch (Exception x) {
                        workbenchFrame.handleThrowable(x);
                    }
                }
            });
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    ViewSchemaPlugIn.this.commitEditsInProgress(panel);
                    if (!layer.isEditable() || !panel.isModified()) {
                        EditSchemaFrame.this.dispose();
                        return;
                    }
                    switch (JOptionPane.showConfirmDialog(EditSchemaFrame.this, "Apply changes to the schema?", "JUMP", 1, 2)) {
                        case 0: {
                            try {
                                ViewSchemaPlugIn.this.applyChanges(layer, panel);
                            }
                            catch (Exception x) {
                                workbenchFrame.handleThrowable(x);
                                return;
                            }
                            EditSchemaFrame.this.dispose();
                            return;
                        }
                        case 1: {
                            EditSchemaFrame.this.dispose();
                            return;
                        }
                        case 2: {
                            return;
                        }
                    }
                    Assert.shouldNeverReachHere();
                }
            });
        }

        private void updateTitle(Layer layer) {
            this.setTitle((layer.isEditable() ? "Edit" : "View") + " Schema: " + layer.getName());
        }

        @Override
        public LayerManager getLayerManager() {
            return this.layerManager;
        }

        @Override
        public Layer chooseEditableLayer() {
            return TreeLayerNamePanel.chooseEditableLayer(this);
        }

        public void surface() {
            if (!this.workbenchFrame.hasInternalFrame(this)) {
                this.workbenchFrame.addInternalFrame(this, false, true);
            }
            this.workbenchFrame.activateFrame(this);
            this.moveToFront();
        }

        @Override
        public LayerNamePanel getLayerNamePanel() {
            return this;
        }

        @Override
        public Collection getSelectedCategories() {
            return new ArrayList();
        }

        @Override
        public Layer[] getSelectedLayers() {
            return new Layer[]{this.layer};
        }

        @Override
        public Collection selectedNodes(Class c) {
            if (!Layerable.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            return Arrays.asList(this.getSelectedLayers());
        }

        @Override
        public void addListener(LayerNamePanelListener listener) {
        }

        @Override
        public void removeListener(LayerNamePanelListener listener) {
        }
    }

    private static class ConversionException
    extends Exception {
        public ConversionException(String message) {
            super(message);
        }
    }
}

