/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.util.CollectionUtil;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.util.Assert;

public class WKTDisplayHelper {
    private static final int LINE_SPLIT_THRESHOLD = -1;

    public String format(String wkt) {
        String formattedWKT = this.format(wkt, false);
        if (formattedWKT.length() > -1) {
            formattedWKT = this.format(wkt, true);
        }
        return formattedWKT;
    }

    private String format(String wkt, boolean splitting) {
        int level = 0;
        String lastNonBlankToken = "";
        StringBuffer formattedWKT = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(wkt, " \t\n\r\f,()", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.trim().length() == 0) continue;
            if (token.equals(",")) {
                formattedWKT.append(", ");
            } else if (token.equals("(")) {
                ++level;
                if (this.wordToken(lastNonBlankToken)) {
                    formattedWKT.append(" ");
                }
                formattedWKT.append("(");
            } else if (token.equals(")")) {
                int oldLevel = level;
                level = Math.max(0, level - 1);
                if (this.wordToken(lastNonBlankToken)) {
                    this.newLineAndIndentIfSplitting(formattedWKT, level, splitting);
                }
                formattedWKT.append(")");
                if (oldLevel == 1) {
                    formattedWKT.append(this.newLine());
                }
            } else {
                if (this.wordToken(lastNonBlankToken)) {
                    formattedWKT.append(" ");
                } else {
                    this.newLineAndIndentIfSplitting(formattedWKT, level, splitting);
                }
                formattedWKT.append(token);
            }
            lastNonBlankToken = token;
        }
        return formattedWKT.toString().trim();
    }

    private String newLine() {
        return "\n";
    }

    private void newLineAndIndentIfSplitting(StringBuffer formattedWKT, int level, boolean splitting) {
        if (splitting) {
            formattedWKT.append(this.newLine() + this.indent(level));
        }
    }

    private boolean wordToken(String token) {
        return !token.equals("(") && !token.equals(")") && !token.equals(",");
    }

    private Integer inc(Object i) {
        return new Integer((Integer)i + 1);
    }

    public String annotate(String wkt) {
        int lineIndex = 0;
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        ArrayList annotations = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(wkt, " \t\n\r\f,()", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                ++lineIndex;
                continue;
            }
            if (token.trim().length() == 0) continue;
            if (token.equals(",")) {
                stack.push(this.inc(stack.pop()));
                continue;
            }
            if (token.equals("(")) {
                stack.push(new Integer(0));
                continue;
            }
            if (token.equals(")")) {
                if (stack.size() == 1) continue;
                stack.pop();
                if (stack.size() != 1) continue;
                stack.push(this.inc(stack.pop()));
                continue;
            }
            if (!StringUtil.isNumber(token)) continue;
            CollectionUtil.setIfNull(lineIndex, annotations, this.annotation(stack));
        }
        CollectionUtil.resize(annotations, lineIndex + 1);
        return StringUtil.toDelimitedString(annotations, this.newLine());
    }

    private String annotation(List indices) {
        String annotation = "";
        for (Integer index : indices.subList(1, indices.size())) {
            if (annotation.trim().length() != 0) {
                annotation = annotation + ":";
            }
            annotation = annotation + index;
        }
        return annotation;
    }

    private String indent(int level) {
        return StringUtil.repeat(' ', level * 4);
    }

    public static void main(String[] args) {
        String wkt = new WKTDisplayHelper().format("POINT(5 5)POINT(10 10)", false);
        System.out.println(wkt);
        System.out.println(new WKTDisplayHelper().annotate(wkt));
    }

    public String annotation(Geometry geometry, Coordinate c) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        Assert.isTrue((boolean)this.annotation(geometry, c, stack));
        return this.annotation(stack);
    }

    private boolean annotation(Geometry geometry, Coordinate c, Stack stack) {
        stack.push(new Integer(0));
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                if (!this.annotation(((GeometryCollection)geometry).getGeometryN(i), c, stack)) continue;
                return true;
            }
        } else if (geometry instanceof Polygon) {
            if (this.annotation((Geometry)((Polygon)geometry).getExteriorRing(), c, stack)) {
                return true;
            }
            for (int i = 0; i < ((Polygon)geometry).getNumInteriorRing(); ++i) {
                if (!this.annotation((Geometry)((Polygon)geometry).getInteriorRingN(i), c, stack)) continue;
                return true;
            }
        } else if (geometry instanceof LineString || geometry instanceof Point) {
            Coordinate[] coordinates = geometry.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                if (coordinates[i] == c) {
                    return true;
                }
                stack.push(this.inc(stack.pop()));
            }
        } else {
            Assert.shouldNeverReachHere();
        }
        stack.pop();
        stack.push(this.inc(stack.pop()));
        return false;
    }
}

