/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.util.Iterator;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.WKTReader;
import org.locationtech.jts.jump.workbench.WorkbenchException;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.EditTransaction;
import org.locationtech.jts.jump.workbench.ui.EnterWKTDialog;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.operation.valid.IsValidOp;

public abstract class WKTPlugIn
extends AbstractPlugIn {
    protected Layer layer;

    private void validate(FeatureCollection c, PlugInContext context) throws WorkbenchException {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            IsValidOp op = new IsValidOp(f.getGeometry());
            if (op.isValid()) continue;
            if (context.getWorkbenchContext().getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                throw new WorkbenchException(op.getValidationError().getMessage());
            }
            context.getWorkbenchFrame().warnUser(op.getValidationError().getMessage());
        }
    }

    protected abstract Layer layer(PlugInContext var1);

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.layer = this.layer(context);
        EnterWKTDialog d = this.createDialog(context);
        d.setVisible(true);
        return d.wasOKPressed();
    }

    protected abstract void apply(FeatureCollection var1, PlugInContext var2) throws WorkbenchException;

    protected EnterWKTDialog createDialog(final PlugInContext context) {
        final EnterWKTDialog d = new EnterWKTDialog(context.getWorkbenchFrame(), "Enter Well-Known Text", true);
        d.setSize(500, 400);
        d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (d.wasOKPressed()) {
                        WKTPlugIn.this.apply(d.getText(), context);
                    }
                    d.setVisible(false);
                }
                catch (Throwable t) {
                    context.getErrorHandler().handleThrowable(t);
                }
            }
        });
        GUIUtil.centreOnWindow(d);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(String wkt, PlugInContext context) throws Exception {
        try (StringReader stringReader = new StringReader(wkt);){
            WKTReader wktReader = new WKTReader();
            FeatureCollection c = wktReader.read(stringReader);
            this.validate(c, context);
            this.apply(c, context);
        }
    }
}

