/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.AbstractTransferable;

public class CollectionOfLayerablesTransferable
extends AbstractTransferable {
    public static final DataFlavor COLLECTION_OF_LAYERABLES_FLAVOR = new DataFlavor((Class)Collection.class, "Collection of Layerables"){

        @Override
        public boolean equals(DataFlavor that) {
            return super.equals(that) && this.getHumanPresentableName().equals(that.getHumanPresentableName());
        }
    };
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor, COLLECTION_OF_LAYERABLES_FLAVOR};
    private Collection layerables;

    public CollectionOfLayerablesTransferable(Collection layerables) {
        super(flavors);
        this.layerables = new ArrayList(layerables);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(COLLECTION_OF_LAYERABLES_FLAVOR)) {
            return Collections.unmodifiableCollection(this.layerables);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.toString(new ArrayList(this.layerables));
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this.toString(new ArrayList(this.layerables)));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String toString(List layerables) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < layerables.size(); ++i) {
            Layerable layerable = (Layerable)layerables.get(i);
            if (i != 0) {
                b.append(", ");
            }
            b.append(layerable.getName());
        }
        return b.toString();
    }
}

