/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.plugin.ExportImagePlugIn;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import org.locationtech.jts.util.Assert;

public class CopyImagePlugIn
extends ExportImagePlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = this.createTransferable(context);
        if (transferable == null) {
            context.getWorkbenchFrame().warnUser("Could not copy the image for some reason");
            return false;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, new DummyClipboardOwner());
        return true;
    }

    private Transferable createTransferable(final PlugInContext context) {
        return new AbstractTransferable(new DataFlavor[]{DataFlavor.imageFlavor}){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                Assert.isTrue((flavor == DataFlavor.imageFlavor ? 1 : 0) != 0);
                return CopyImagePlugIn.this.image(context.getLayerViewPanel());
            }
        };
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !CopyImagePlugIn.java14OrNewer() ? "This feature requires Java 1.4 or newer" : null;
            }
        });
    }
}

