/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.clipboard;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import org.locationtech.jts.jump.workbench.ui.plugin.clipboard.LayerableClipboardPlugIn;

public class CopySelectedLayersPlugIn
extends LayerableClipboardPlugIn {
    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "C", "&C", false);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new CollectionOfLayerablesTransferable(this.clone(context.getLayerNamePanel().selectedNodes(Layerable.class))), new DummyClipboardOwner());
        return true;
    }

    private Collection clone(Collection layerables) {
        ArrayList<Layerable> clones = new ArrayList<Layerable>();
        for (Layerable layerable : layerables) {
            if (!(layerable instanceof Layer) && !(layerable instanceof WMSLayer)) continue;
            clones.add(this.cloneLayerable(layerable));
        }
        return clones;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }
}

