/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.generate;

import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.MultiInputDialog;
import org.locationtech.jts.jump.workbench.ui.plugin.generate.BoundaryMatchDataEngine;

public class BoundaryMatchDataPlugIn
extends AbstractPlugIn {
    private BoundaryMatchDataEngine engine = new BoundaryMatchDataEngine();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addLayerViewMenuItem((PlugIn)this, new String[]{"Tools", "Generate"}, this.getName() + "...");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Generate Boundary Match Data", true);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.engine.execute(context);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog) {
        dialog.setTitle("Generate Boundary Match Data");
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("GenerateBdyMatchData.gif")));
        dialog.setSideBarDescription("Generates two sample datasets containing random boundary perturbations");
        dialog.addPositiveIntegerField("Layer Width (cells)", this.engine.getLayerWidthInCells(), 5);
        dialog.addPositiveIntegerField("Layer Height (cells)", this.engine.getLayerHeightInCells(), 5);
        dialog.addPositiveDoubleField("Cell Side Length", this.engine.getCellSideLength(), 5);
        dialog.addPositiveIntegerField("Vertices Per Cell Side", this.engine.getVerticesPerCellSide(), 5);
        dialog.addPositiveIntegerField("Vertices Per Boundary Side", this.engine.getVerticesPerBoundarySide(), 5);
        dialog.addNonNegativeDoubleField("Boundary Amplitude", this.engine.getBoundaryAmplitude(), 5);
        dialog.addPositiveDoubleField("Boundary Period", this.engine.getBoundaryPeriod(), 5);
        dialog.addNonNegativeDoubleField("Max Boundary Perturbation", this.engine.getMaxBoundaryPerturbation(), 5);
        dialog.addNonNegativeDoubleField("Perturbation Probability", this.engine.getPerturbationProbability(), 5);
        dialog.addDoubleField("Min X", this.engine.getSouthwestCornerOfLeftLayer().x, 5);
        dialog.addDoubleField("Min Y", this.engine.getSouthwestCornerOfLeftLayer().y, 5);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.engine.setSouthwestCornerOfLeftLayer(new Coordinate(dialog.getDouble("Min X"), dialog.getDouble("Min Y")));
        this.engine.setLayerHeightInCells(dialog.getInteger("Layer Height (cells)"));
        this.engine.setLayerWidthInCells(dialog.getInteger("Layer Width (cells)"));
        this.engine.setCellSideLength(dialog.getDouble("Cell Side Length"));
        this.engine.setVerticesPerCellSide(dialog.getInteger("Vertices Per Cell Side"));
        this.engine.setBoundaryAmplitude(dialog.getDouble("Boundary Amplitude"));
        this.engine.setBoundaryPeriod(dialog.getDouble("Boundary Period"));
        this.engine.setVerticesPerBoundarySide(dialog.getInteger("Vertices Per Boundary Side"));
        this.engine.setMaxBoundaryPerturbation(dialog.getDouble("Max Boundary Perturbation"));
        this.engine.setPerturbationProbability(dialog.getDouble("Perturbation Probability"));
    }
}

