/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.scalebar;

import java.text.DecimalFormat;
import org.locationtech.jts.jump.workbench.ui.plugin.scalebar.Unit;

public class RoundQuantity {
    private Unit unit;
    private int mantissa;
    private int exponent;

    public RoundQuantity(int mantissa, int exponent, Unit unit) {
        this.mantissa = mantissa;
        this.exponent = exponent;
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getMantissa() {
        return this.mantissa;
    }

    public String toString() {
        return this.getAmountString() + " " + this.getUnit();
    }

    public String getAmountString() {
        if (this.getMantissa() == 0) {
            return "0";
        }
        if (0 <= this.getExponent() && this.getExponent() <= 3) {
            return new DecimalFormat("#").format(this.getAmount());
        }
        if (-4 <= this.getExponent() && this.getExponent() < 0) {
            return new DecimalFormat("#.####").format(this.getAmount());
        }
        return this.getMantissa() + "E" + this.getExponent();
    }

    public int getExponent() {
        return this.exponent;
    }

    public double getAmount() {
        return (double)this.mantissa * Math.pow(10.0, this.exponent);
    }

    public double getModelValue() {
        return this.getAmount() * this.unit.getModelValue();
    }
}

