/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.test;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureCollectionWrapper;
import org.locationtech.jts.jump.feature.FeatureDatasetFactory;
import org.locationtech.jts.jump.geom.GeometryMicroscope;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;

public class MicroscopePlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        EnableCheckFactory checkFactory = new EnableCheckFactory(context.getWorkbenchContext());
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{"Tools", "Test"}, this.getName(), false, null, new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        FeatureCollectionWrapper fc = context.getSelectedLayer(0).getFeatureCollectionWrapper();
        Envelope fence = context.getLayerViewPanel().getFence().getEnvelopeInternal();
        FeatureCollection magFC = this.magnify(fc, fence);
        Layer lyr = context.addLayer("QA", "Microscope", magFC);
        lyr.getBasicStyle().setFillColor(Color.red);
        lyr.getBasicStyle().setLineColor(Color.red);
        lyr.getBasicStyle().setAlpha(100);
        lyr.getVertexStyle().setEnabled(true);
        lyr.fireAppearanceChanged();
        return true;
    }

    private FeatureCollection magnify(FeatureCollection fc, Envelope env) {
        ArrayList<Object> geomList = new ArrayList<Object>();
        for (Feature feature : fc.query(env)) {
            geomList.add(feature.getGeometry().clone());
        }
        double minSep = env.getWidth() / 20.0;
        GeometryMicroscope micro = new GeometryMicroscope(geomList, env, minSep);
        List result = micro.getAdjusted();
        return FeatureDatasetFactory.createFromGeometry(result);
    }
}

