/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.wms;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.jump.workbench.model.UndoableCommand;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.plugin.wms.MapLayerWizardPanel;
import org.locationtech.jts.jump.workbench.ui.plugin.wms.OneSRSWizardPanel;
import org.locationtech.jts.jump.workbench.ui.plugin.wms.SRSWizardPanel;
import org.locationtech.jts.jump.workbench.ui.plugin.wms.URLWizardPanel;
import org.locationtech.jts.jump.workbench.ui.wizard.WizardDialog;
import org.locationtech.jts.jump.workbench.ui.wizard.WizardPanel;
import org.locationtech.jts.wms.MapLayer;
import org.locationtech.jts.wms.WMService;

public class AddWMSQueryPlugIn
extends AbstractPlugIn {
    private String cachedURL = "http://";

    private List toLayerNames(List mapLayers) {
        ArrayList<String> names = new ArrayList<String>();
        for (MapLayer layer : mapLayers) {
            names.add(layer.getName());
        }
        return names;
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        WizardDialog d = new WizardDialog((Frame)context.getWorkbenchFrame(), "Connect To Web Map Server", context.getErrorHandler());
        d.init(new WizardPanel[]{new URLWizardPanel(this.cachedURL), new MapLayerWizardPanel(), new SRSWizardPanel(), new OneSRSWizardPanel()});
        d.setSize(500, 400);
        GUIUtil.centreOnWindow(d);
        d.setVisible(true);
        if (!d.wasFinishPressed()) {
            return false;
        }
        final WMSLayer layer = new WMSLayer(context.getLayerManager(), (WMService)d.getData("SERVICE"), (String)d.getData("SRS"), this.toLayerNames((List)d.getData("LAYERS")), (String)d.getData("FORMAT"));
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
                context.getLayerManager().addLayerable(selectedCategories.isEmpty() ? "Working" : selectedCategories.iterator().next().toString(), layer);
            }

            @Override
            public void unexecute() {
                context.getLayerManager().remove(layer);
            }
        }, context);
        this.cachedURL = (String)d.getData("URL");
        return true;
    }
}

