/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.plugin.wms;

import java.awt.Dimension;
import javax.swing.JLabel;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.model.WMSLayer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.MultiInputDialog;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.plugin.wms.EditWMSQueryPanel;
import org.locationtech.jts.wms.MapLayer;

public class EditWMSQueryPlugIn
extends AbstractPlugIn {
    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WMSLayer layer = (WMSLayer)context.getLayerNamePanel().selectedNodes(WMSLayer.class).iterator().next();
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Edit WMS Query", true);
        dialog.setInset(0);
        dialog.setSideBarImage(IconLoader.icon("EditWMSLayer.jpg"));
        dialog.setSideBarDescription("This dialog enables you to change the layers being retrieved from a Web Map Server.");
        EditWMSQueryPanel panel = new EditWMSQueryPanel(layer.getService(), layer.getLayerNames(), layer.getSRS(), layer.getAlpha());
        panel.setPreferredSize(new Dimension(600, 450));
        dialog.addRow("Chosen Layers", new JLabel(""), panel, panel.getEnableChecks(), null);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            layer.removeAllLayerNames();
            for (MapLayer mapLayer : panel.getChosenMapLayers()) {
                layer.addLayerName(mapLayer.getName());
            }
            layer.setSRS(panel.getSRS());
            layer.setAlpha(panel.getAlpha());
            layer.fireAppearanceChanged();
            return true;
        }
        return false;
    }
}

