/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.ThreadSafeImage;
import org.locationtech.jts.jump.workbench.ui.renderer.style.Style;

public class LayerRenderer
extends FeatureCollectionRenderer {
    private Layer layer;
    private LayerViewPanel panel;

    public LayerRenderer(final Layer layer, LayerViewPanel panel) {
        super(layer, panel, new ImageCachingFeatureCollectionRenderer(layer, panel){

            @Override
            protected ThreadSafeImage getImage() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.getImage();
            }

            @Override
            public Runnable createRunnable() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.createRunnable();
            }
        });
        this.layer = layer;
        this.panel = panel;
    }

    @Override
    protected Collection styles() {
        ArrayList<Style> styles = new ArrayList<Style>(this.layer.getStyles());
        styles.remove(this.layer.getVertexStyle());
        styles.remove(this.layer.getLabelStyle());
        styles.add(this.layer.getVertexStyle());
        styles.add(this.layer.getLabelStyle());
        return styles;
    }

    @Override
    protected Map layerToFeaturesMap() {
        Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
        return Collections.singletonMap(this.layer, this.layer.getFeatureCollectionWrapper().query(viewportEnvelope));
    }
}

