/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.renderer.java2D;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import org.locationtech.jts.jump.workbench.ui.renderer.java2D.PolygonShape;

public class Java2DConverter {
    private static double POINT_MARKER_SIZE = 3.0;
    private PointConverter pointConverter;

    public Java2DConverter(PointConverter pointConverter) {
        this.pointConverter = pointConverter;
    }

    private Shape toShape(Polygon p) throws NoninvertibleTransformException {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            holeVertexCollection.add(this.toViewCoordinates(p.getInteriorRingN(j).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection);
    }

    private Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) throws NoninvertibleTransformException {
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        for (int i = 0; i < modelCoordinates.length; ++i) {
            Point2D point2D = this.toViewPoint(modelCoordinates[i]);
            viewCoordinates[i] = new Coordinate(point2D.getX(), point2D.getY());
        }
        return viewCoordinates;
    }

    private Shape toShape(GeometryCollection gc) throws NoninvertibleTransformException {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) throws NoninvertibleTransformException {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) throws NoninvertibleTransformException {
        GeneralPath shape = new GeneralPath();
        Point2D viewPoint = this.toViewPoint(lineString.getCoordinateN(0));
        shape.moveTo((float)viewPoint.getX(), (float)viewPoint.getY());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            viewPoint = this.toViewPoint(lineString.getCoordinateN(i));
            shape.lineTo((float)viewPoint.getX(), (float)viewPoint.getY());
        }
        return shape;
    }

    private Shape toShape(Point point) throws NoninvertibleTransformException {
        Rectangle2D.Double pointMarker = new Rectangle2D.Double(0.0, 0.0, POINT_MARKER_SIZE, POINT_MARKER_SIZE);
        Point2D viewPoint = this.toViewPoint(point.getCoordinate());
        pointMarker.x = viewPoint.getX() - POINT_MARKER_SIZE / 2.0;
        pointMarker.y = viewPoint.getY() - POINT_MARKER_SIZE / 2.0;
        return pointMarker;
    }

    private Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        Point2D viewPoint = this.pointConverter.toViewPoint(modelCoordinate);
        viewPoint.setLocation(Math.round(viewPoint.getX()), Math.round(viewPoint.getY()));
        return viewPoint;
    }

    public Shape toShape(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)((MultiPolygon)geometry));
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1) throws NoninvertibleTransformException;
    }
}

