/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.snap;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.snap.SnapPolicy;

public class SnapManager {
    private static final String TOLERANCE_IN_PIXELS_KEY = SnapManager.class.getName() + " - TOLERANCE IN PIXELS";
    private ArrayList policies = new ArrayList();
    private boolean snapCoordinateFound;

    public Coordinate snap(LayerViewPanel panel, Coordinate originalCoordinate) {
        for (SnapPolicy policy : this.policies) {
            Coordinate snapCoordinate = policy.snap(panel, originalCoordinate);
            if (snapCoordinate == null) continue;
            this.snapCoordinateFound = true;
            return snapCoordinate;
        }
        this.snapCoordinateFound = false;
        return originalCoordinate;
    }

    public void addPolicies(Collection policies) {
        this.policies.addAll(policies);
    }

    public boolean wasSnapCoordinateFound() {
        return this.snapCoordinateFound;
    }

    public static int getToleranceInPixels(Blackboard blackboard) {
        return blackboard.get(TOLERANCE_IN_PIXELS_KEY, 10);
    }

    public static void setToleranceInPixels(int toleranceInPixels, Blackboard blackboard) {
        blackboard.put(TOLERANCE_IN_PIXELS_KEY, toleranceInPixels);
    }
}

