/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.snap;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.jump.geom.InteriorPointFinder;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.snap.SnapManager;
import org.locationtech.jts.jump.workbench.ui.snap.SnapPolicy;
import org.locationtech.jts.jump.workbench.ui.snap.VisiblePointsAndLinesCache;

public class SnapToFeaturesPolicy
implements SnapPolicy {
    private Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToFeaturesPolicy.class.getName() + " - ENABLED";
    private InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private GeometryFactory factory = new GeometryFactory();

    public SnapToFeaturesPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    public SnapToFeaturesPolicy() {
        this(new Blackboard());
        this.blackboard.put(ENABLED_KEY, true);
    }

    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalCoordinate) {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return null;
        }
        Geometry bufferedTransformedCursorLocation = this.factory.createPoint(originalCoordinate).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        for (Geometry candidate : VisiblePointsAndLinesCache.instance(panel).getTree().query(bufferedTransformedCursorLocation.getEnvelopeInternal())) {
            Geometry intersection = candidate.intersection(bufferedTransformedCursorLocation);
            if (intersection.isEmpty()) continue;
            return this.interiorPointFinder.findPoint(intersection);
        }
        return null;
    }
}

