/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.snap;

import java.util.ArrayList;
import java.util.Iterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.ViewportListener;
import org.locationtech.jts.util.Assert;

public class VisiblePointsAndLinesCache {
    private static final String PANEL_PROPERTY_KEY = "VISIBLE_POINTS_AND_LINES_CACHE";
    private LayerListener layerListener = new LayerListener(){

        @Override
        public void layerChanged(LayerEvent e) {
            VisiblePointsAndLinesCache.this.invalidate();
        }

        @Override
        public void featuresChanged(FeatureEvent e) {
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    };
    private ViewportListener viewportListener = new ViewportListener(){

        @Override
        public void zoomChanged(Envelope modelEnvelope) {
            VisiblePointsAndLinesCache.this.invalidate();
        }
    };
    private LayerViewPanel panel;
    private GeometryFactory factory = new GeometryFactory();
    private STRtree tree = null;

    private VisiblePointsAndLinesCache(LayerViewPanel panel) {
        this.panel = panel;
        panel.getViewport().addListener(this.viewportListener);
        panel.getLayerManager().addLayerListener(this.layerListener);
    }

    private void invalidate() {
        this.tree = null;
    }

    public STRtree getTree() {
        if (this.tree == null) {
            Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
            this.tree = new STRtree();
            Iterator i = this.panel.getLayerManager().iterator();
            while (i.hasNext()) {
                Layer layer = (Layer)i.next();
                if (!layer.isVisible()) continue;
                for (Feature feature : layer.getFeatureCollectionWrapper().query(viewportEnvelope)) {
                    Geometry geometry = feature.getGeometry();
                    this.tree.insert(geometry.getEnvelopeInternal(), (Object)this.toPointsAndLines(geometry));
                }
            }
        }
        return this.tree;
    }

    private Geometry toPointsAndLines(Geometry g) {
        if (g.getDimension() <= 1) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection oldCollection = (GeometryCollection)g;
            ArrayList<Geometry> newCollection = new ArrayList<Geometry>();
            for (int i = 0; i < oldCollection.getNumGeometries(); ++i) {
                newCollection.add(this.toPointsAndLines(oldCollection.getGeometryN(i)));
            }
            return this.factory.createGeometryCollection(newCollection.toArray(new Geometry[0]));
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        return ((Polygon)g).getBoundary();
    }

    public static VisiblePointsAndLinesCache instance(LayerViewPanel panel) {
        if (panel.getBlackboard().get(PANEL_PROPERTY_KEY) == null) {
            return (VisiblePointsAndLinesCache)panel.getBlackboard().get(PANEL_PROPERTY_KEY, new VisiblePointsAndLinesCache(panel));
        }
        return (VisiblePointsAndLinesCache)panel.getBlackboard().get(PANEL_PROPERTY_KEY);
    }
}

