/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.zoom;

import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.jump.geom.EnvelopeUtil;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;

public class ZoomToLayerPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        context.getLayerViewPanel().getViewport().zoom(EnvelopeUtil.bufferByFraction(this.envelopeOfSelectedLayers(context), 0.03));
        return true;
    }

    private Envelope envelopeOfSelectedLayers(PlugInContext context) {
        Envelope envelope = new Envelope();
        for (Layer layer : Arrays.asList(context.getLayerNamePanel().getSelectedLayers())) {
            envelope.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
        }
        return envelope;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ((JMenuItem)component).setText(ZoomToLayerPlugIn.this.getName() + StringUtil.s(workbenchContext.getLayerNamePanel().getSelectedLayers().length));
                return null;
            }
        });
    }
}

